﻿using Siger.Middlelayer.DashboardRepository.Entities;
using Siger.Middlelayer.DashboardRepository.Repositories.Interface;
using Siger.Middlelayer.DashboardRepository.Request;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

namespace Siger.Middlelayer.DashboardRepository.Repositories
{
    internal class DeviceStatusSummaryDataRepository : DashboardRepositoryBase<siger_tr_cjrf_device_status_summary_data>, IDeviceStatusSummaryDataRepository
    {
        private readonly ApiDashboardDbContext _context;
        public DeviceStatusSummaryDataRepository(ApiDashboardDbContext context) : base(context)
        {
            _context = context;
        }

        public bool AddCjrf(RequestSigerTrCjrfList ret, int projectId)
        {
            if (Delete(projectId))
            {
                if (ret.alarm != null)
                {
                    foreach (var item in ret.alarm)
                    {
                        var entities = new siger_tr_cjrf_today_alarm_top5()
                        {
                            projectid = projectId,
                            station = item.station,
                            duration = item.duration
                        };
                        _context.siger_tr_cjrf_today_alarm_top5.Add(entities);
                    }
                }

                if (ret.device != null)
                {
                    var entities = new siger_tr_cjrf_device_status_summary_data()
                    {
                        projectid = projectId,
                        runNum = ret.device.runNum,
                        debugNum = ret.device.debugNum,
                        freeNum = ret.device.freeNum,
                        errorNum = ret.device.errorNum,
                        closeNum = ret.device.closeNum
                    };
                    _context.siger_tr_cjrf_device_status_summary_data.Add(entities);
                }

                if (ret.distribute != null)
                {
                    var entities = new siger_tr_cjrf_device_status_distribute_data()
                    {
                        projectid = projectId,
                        hour1 = ret.distribute.hour1,
                        hour2 = ret.distribute.hour2,
                        hour3 = ret.distribute.hour3,
                        hour4 = ret.distribute.hour4,
                        hour5 = ret.distribute.hour5
                    };
                    _context.siger_tr_cjrf_device_status_distribute_data.Add(entities);
                }

                if (ret.efficiency != null)
                {
                    foreach (var item in ret.efficiency)
                    {
                        var entities = new siger_tr_cjrf_time_efficiency_top10()
                        {
                            projectid = projectId,
                            station = item.station,
                            percent = item.percent
                        };
                        _context.siger_tr_cjrf_time_efficiency_top10.Add(entities);
                    }
                }

                if (ret.realtime != null)
                {
                    foreach (var item in ret.realtime)
                    {
                        var entities = new siger_tr_cjrf_device_real_time_status()
                        {
                            projectid = projectId,
                            station = item.station,
                            deviceNo = item.deviceNo,
                            deviceName = item.deviceName,
                            devicePurpose = item.devicePurpose,
                            deviceWarn = item.deviceWarn,
                            duration = item.duration,
                            x = item.x,
                            y = item.y,
                            current_status = item.current_status,
                            type = item.type
                        };
                        _context.siger_tr_cjrf_device_real_time_status.Add(entities);
                    }
                }

                if (ret.timealarm != null)
                {
                    foreach (var item in ret.timealarm)
                    {
                        var entities = new siger_tr_cjrf_realtime_alarm()
                        {
                            projectid = projectId,
                            station = item.station,
                            alarmContent = item.alarmContent,
                            duration = item.duration
                        };
                        _context.siger_tr_cjrf_realtime_alarm.Add(entities);
                    }
                }

                if (ret.timeefficiency != null)
                {
                    var entities = new siger_tr_cjrf_time_efficiency()
                    {
                        projectid = projectId,
                        timeEfficiencyV = ret.timeefficiency.timeEfficiencyV
                    };
                    _context.siger_tr_cjrf_time_efficiency.Add(entities);
                }
                if (_context.SaveChanges() < 0)
                {
                    return false;
                }
                return true;
            }
            return false;
        }

        public RequestSigerTrCjrfList GetAllCjrf(int projectId)
        {
            var result = new RequestSigerTrCjrfList();
            var alarmList = new List<RequestSigerTrCjrfAlarmTop5>();
            var efficiencyList = new List<RequestTimeEfficiencyTop10List>();
            var timeEfficiencyList = new RequestTimeEfficiency();
            var timeAlarmList = new List<RequestRealtimeAlarmList>();
            var devices = new RequestDeviceStatusSummaryData();
            var realtimeList = new List<RequestDeviceRealTimeStatusList>();
            var distribute = new RequestDeviceStatusDistributeData();

            var deviceLists = _context.siger_tr_cjrf_device_real_time_status.Where(q => q.status > 0 && q.projectid == projectId).ToList();
            if (deviceLists != null)
            {
                foreach (var item in deviceLists)
                {
                    var entities = new RequestDeviceRealTimeStatusList()
                    {
                        station = item.station,
                        deviceNo = item.deviceNo,
                        deviceName = item.deviceName,
                        devicePurpose = item.devicePurpose,
                        deviceWarn = item.deviceWarn,
                        duration = item.duration,
                        x = item.x,
                        y = item.y,
                        current_status = item.current_status,
                        type = item.type
                    };
                    realtimeList.Add(entities);
                }
            }
            var distributeList = _context.siger_tr_cjrf_device_status_distribute_data.Where(q => q.status > 0 && q.projectid == projectId).FirstOrDefault();
            if (distributeList != null)
            {
                distribute.hour1 = distributeList.hour1;
                distribute.hour2 = distributeList.hour2;
                distribute.hour3 = distributeList.hour3;
                distribute.hour4 = distributeList.hour4;
                distribute.hour5 = distributeList.hour5;
            }
            var summary = _context.siger_tr_cjrf_device_status_summary_data.Where(q => q.status > 0 && q.projectid == projectId).FirstOrDefault();
            if (summary != null)
            {
                devices.runNum = summary.runNum;
                devices.debugNum = summary.debugNum;
                devices.freeNum = summary.freeNum;
                devices.errorNum = summary.errorNum;
                devices.closeNum = summary.closeNum;
            }
            var realtimeLists = _context.siger_tr_cjrf_realtime_alarm.Where(q => q.status > 0 && q.projectid == projectId).ToList();
            if (realtimeLists != null)
            {
                foreach (var item in realtimeLists)
                {
                    var entities = new RequestRealtimeAlarmList()
                    {
                        station = item.station,
                        alarmContent = item.alarmContent,
                        duration = item.duration
                    };
                    timeAlarmList.Add(entities);
                }
            }
            var efficiencysList = _context.siger_tr_cjrf_time_efficiency.Where(q => q.status > 0 && q.projectid == projectId).FirstOrDefault();
            if (efficiencysList != null)
            {
                timeEfficiencyList.timeEfficiencyV = efficiencysList.timeEfficiencyV;
            }
            var efficiencyLists = _context.siger_tr_cjrf_time_efficiency_top10.Where(q => q.status > 0 && q.projectid == projectId).ToList();
            if (efficiencyLists != null)
            {
                foreach (var item in efficiencyLists)
                {
                    var entities = new RequestTimeEfficiencyTop10List()
                    {
                        station = item.station,
                        percent = item.percent
                    };
                    efficiencyList.Add(entities);
                }
            }
            var alarmLists = _context.siger_tr_cjrf_today_alarm_top5.Where(q => q.status > 0 && q.projectid == projectId).ToList();
            if (alarmLists != null)
            {
                foreach (var item in alarmLists)
                {
                    var entities = new RequestSigerTrCjrfAlarmTop5()
                    {
                        station = item.station,
                        duration = item.duration
                    };
                    alarmList.Add(entities);
                }
            }
            var efficiency = efficiencyList.OrderByDescending(q => q.percent).ToList();
            var query= alarmList.OrderByDescending(q => q.duration).ToList();
            result.alarm = query;
            result.device = devices;
            result.distribute = distribute;
            result.efficiency = efficiency;
            result.realtime = realtimeList;
            result.timealarm = timeAlarmList;
            result.timeefficiency = timeEfficiencyList;

            return result;
        }

        private bool Delete(int projectId)
        {
            var deviceList = _context.siger_tr_cjrf_device_real_time_status.Where(q => q.status > 0 && q.projectid == projectId).ToList();
            if (deviceList != null)
            {
                foreach (var item in deviceList)
                {
                    _context.siger_tr_cjrf_device_real_time_status.Remove(item);
                }
            }
            var distributeList = _context.siger_tr_cjrf_device_status_distribute_data.Where(q => q.status > 0 && q.projectid == projectId).ToList();
            if (distributeList != null)
            {
                foreach (var item in distributeList)
                {
                    _context.siger_tr_cjrf_device_status_distribute_data.Remove(item);
                }
            }
            var summaryList = _context.siger_tr_cjrf_device_status_summary_data.Where(q => q.status > 0 && q.projectid == projectId).ToList();
            if (summaryList != null)
            {
                foreach (var item in summaryList)
                {
                    _context.siger_tr_cjrf_device_status_summary_data.Remove(item);
                }
            }
            var realtimeList = _context.siger_tr_cjrf_realtime_alarm.Where(q => q.status > 0 && q.projectid == projectId).ToList();
            if (realtimeList != null)
            {
                foreach (var item in realtimeList)
                {
                    _context.siger_tr_cjrf_realtime_alarm.Remove(item);
                }
            }
            var efficiencyList = _context.siger_tr_cjrf_time_efficiency.Where(q => q.status > 0 && q.projectid == projectId).ToList();
            if (efficiencyList != null)
            {
                foreach (var item in efficiencyList)
                {
                    _context.siger_tr_cjrf_time_efficiency.Remove(item);
                }
            }
            var efficiencyLists = _context.siger_tr_cjrf_time_efficiency_top10.Where(q => q.status > 0 && q.projectid == projectId).ToList();
            if (efficiencyLists != null)
            {
                foreach (var item in efficiencyLists)
                {
                    _context.siger_tr_cjrf_time_efficiency_top10.Remove(item);
                }
            }
            var alarmList = _context.siger_tr_cjrf_today_alarm_top5.Where(q => q.status > 0 && q.projectid == projectId).ToList();
            if (alarmList != null)
            {
                foreach (var item in alarmList)
                {
                    _context.siger_tr_cjrf_today_alarm_top5.Remove(item);
                }
            }
            if (_context.SaveChanges() < 0)
            {
                return false;
            }

            return true;
        }
    }
}
