﻿using Siger.Middlelayer.DashboardRepository.Entities;
using Siger.Middlelayer.DashboardRepository.Response;
using Siger.Middlelayer.Share.Enum.ModuleEnum;
using Siger.Middlelayer.TpmRepository.Entities;
using Siger.Middlelayer.TpmRepository.Response;
using System;
using System.Collections.Generic;
using System.Text;

namespace Siger.Middlelayer.DashboardRepository.Repositories.Interface
{
    public interface IDashboardLevelRepository : IDashboardRepositoryBase<siger_dashboard_level_config>
    {
        void GetTimeRange(string date, int project_id, out DateTime dtStart, out DateTime dtEnd, int section = 0, DashboardEnum dashboard = DashboardEnum.Chanel);
        DateTime StartDate(string date);

        double ProductTarget(int projectId, double second, string productCode);

        /// <summary>
        /// 安灯计划停机数据
        /// </summary>
        /// <param name="projectId"></param>
        /// <param name="sections"></param>
        /// <param name="dtStart"></param>
        /// <param name="dtEnd"></param>
        /// <returns></returns>
        IEnumerable<siger_andon_info> AndonPlanStopData(int projectId, List<int> sections, DateTime dtStart, DateTime dtEnd);
        /// <summary>
        /// 安灯切片
        /// </summary>
        /// <param name="dtStart"></param>
        /// <param name="datasource"></param>
        /// <returns></returns>
        IEnumerable<ResponseAndonSlice> GetAndonSlice(DateTime dtStart, IEnumerable<siger_andon_info> datasource);

        /// <summary>
        /// 计划停机时间
        /// </summary>
        /// <param name="projectId"></param>
        /// <param name="time"></param>
        /// <param name="mid"></param>
        /// <param name="begin"></param>
        /// <param name="end"></param>
        /// <returns></returns>
        double GetStopTime(int projectId, double time, int mid, DateTime begin, DateTime end);

        /// <summary>
        /// 瓶颈工位
        /// </summary>
        /// <param name="sections">产线/工位</param>
        /// <param name="projectId">项目</param>
        /// <param name="mid">返回设备ID</param>
        /// <returns></returns>
        IEnumerable<int> GetBottleSection(List<int> sections,int projectId,bool mid=true);

        /// <summary>
        /// 瓶颈工位
        /// </summary>
        /// <param name="projectId">项目</param>
        /// <returns></returns>
        IEnumerable<ResponseLevelSectionMachine> GetBottleSection(int projectId);

        /// <summary>
        ///  瓶颈工位 换型产品
        /// </summary>
        /// <param name="projectId"></param>
        /// <param name="machineIds">瓶颈工位</param>
        /// <param name="stime"></param>
        /// <param name="etime"></param>
        /// <returns></returns>
        IEnumerable<ResponseAndoProductType> GetAndonProductName(int projectId, int machineIds, DateTime stime, DateTime etime);

        ResponseAndoProductType GetAndonLastChangeProduct(int projectId, int machineIds, DateTime stime, DateTime etime);

        /// <summary>
        /// 每小时范围内 瓶颈工位产品目标产值
        /// </summary>
        /// <param name="projectId"></param>
        /// <param name="bottleMachine"></param>
        /// <param name="stepStartDate"></param>
        /// <param name="stepEndDate"></param>
        /// <returns></returns>
        ResponseProductTarget BottleProductTarget(int projectId, int bottleMachine, DateTime stepStartDate, DateTime stepEndDate);
        List<ResponseProductTarget> BottleProductTarget(int projectId, List<int> machines, DateTime stepStartDate, DateTime stepEndDate);
    }
}
