﻿using Siger.Middlelayer.TpmRepository.Entities;
using System;
using System.Collections.Generic;
using System.ComponentModel.DataAnnotations.Schema;
using System.Linq;
using System.Text;

namespace Siger.Middlelayer.DashboardRepository.Response
{
    public class ResponseRepair : TpmEntityBase
    {
        public int machineid { get; set; } = 0;

        /// <summary>
        /// 
        /// </summary>
        public int createtime { get; set; } = 0;

        /// <summary>
        /// project_machine_fault.id 故障内容 如果为0，表示其他
        /// </summary>
        public int faultid { get; set; } = 0;

        /// <summary>
        /// 项目id
        /// </summary>
        public int projectid { get; set; }

        /// <summary>
        /// 创建人的mid
        /// </summary>
        public int mid { get; set; } = 0;

        /// <summary>
        /// 如果fault为0，则填写此项。 其他故障原因
        /// </summary>
        public string remark { get; set; } = string.Empty;

        // 1待接单，2已接单;待签到，3待维修，4签到;待复线，5维修完成,待反馈，6已完成，7已完成，0->删除
        //public int status { get; set; }

        /// <summary>
        /// 存放图片的url，用逗号隔开
        /// </summary>
        public string images { get; set; } = string.Empty;

        /// <summary>
        /// 接单人的mid
        /// </summary>
        public int takemid { get; set; } = 0;

        /// <summary>
        /// 拒绝维修信息
        /// </summary>
        public string refuse_repair_info { get; set; } = string.Empty;

        /// <summary>
        /// 签到人的mid
        /// </summary>
        public int signmid { get; set; } = 0;

        /// <summary>
        /// 接单时间
        /// </summary>
        public int taketime { get; set; } = 0;

        /// <summary>
        /// 维修签到时间
        /// </summary>
        public int signtime { get; set; } = 0;

        /// <summary>
        /// 提交维修反馈人
        /// </summary>
        public int repairmid { get; set; } = 0;

        /// <summary>
        /// (完成后)提交信息的时间
        /// </summary>
        public int repairtime { get; set; } = 0;

        /// <summary>
        /// 复线操作人mid
        /// </summary>
        public int checkmid { get; set; } = 0;

        /// <summary>
        /// 复线时间
        /// </summary>
        public int checktime { get; set; } = 0;

        /// <summary>
        /// 复线拒绝的原因
        /// </summary>
        public string refuse_recovery_info { get; set; } = string.Empty;

        /// <summary>
        /// 故障现象描述
        /// </summary>
        public string fault_description { get; set; } = string.Empty;

        /// <summary>
        /// 拒绝复线上次工单id
        /// </summary>
        public int last_repair_record { get; set; } = 0;

        /// <summary>
        /// 故障现象描述图片
        /// </summary>
        public string fault_desc_img { get; set; } = string.Empty;

        /// <summary>
        /// 维修排查过程描述
        /// </summary>
        public string repair_process { get; set; } = string.Empty;

        /// <summary>
        /// 故障原因 _project_machine_fault
        /// </summary>
        public int real_faultid { get; set; } = 0;

        /// <summary>
        /// 故障原因描述
        /// </summary>
        public string real_faultid_desc { get; set; } = string.Empty;

        /// <summary>
        /// 所用备件(id) 如果多个用逗号隔开
        /// </summary>
        public string sparepartid { get; set; } = string.Empty;

        /// <summary>
        /// 维修过程备注（其他备件名称等）
        /// </summary>
        public string repair_remark { get; set; } = string.Empty;

        /// <summary>
        /// 0=>未停线 1=>停线
        /// </summary>
        public int offlinestatus { get; set; } = 0;

        /// <summary>
        /// 完成维修mid
        /// </summary>
        public int completemid { get; set; } = 0;

        /// <summary>
        /// 完成维修时间
        /// </summary>
        public int completetime { get; set; } = 0;

        /// <summary>
        /// 关联出库单号
        /// </summary>
        public string sparepartout { get; set; } = string.Empty;

        /// <summary>
        /// 工单当前异常上报等级
        /// </summary>
        public int report_level { get; set; } = 0;

        /// <summary>
        /// 参与维修人
        /// </summary>
        public string add_repairmid { get; set; } = string.Empty;

        /// <summary>
        ///工单类型 1:应急维修单 2:事后维修单 3: 计划维修单
        /// </summary>
        public int work_type { get; set; } = 1;

        /// <summary>
        /// 带病复线关联工单id
        /// </summary>
        public int relate_repairid { get; set; } = 0;

        /// <summary>
        /// 评价 1-5分
        /// </summary>
        public int appraise { get; set; } = 0;

        /// <summary>
        /// 成本目的
        /// </summary>
        public int cost_purpose { get; set; } = 0;
        public string work_order { get; set; } = string.Empty;
        public int expection_id { get; set; } = 0;
    }

    public class ResponsePlan : TpmEntityBase
    {
        /// <summary>
        /// _project_plan_item.id
        /// </summary>
        public int itemid { get; set; } = 0;

        /// <summary>
        /// _project_machine.id
        /// </summary>
        public int machineid { get; set; } = 0;

        /// <summary>
        /// 第一次执行时间
        /// </summary>
        public string first_instruction_time { get; set; } = string.Empty;

        /// <summary>
        /// 执行周期（天） 注意和_project_plan_item.instruction_cycle保持一致
        /// </summary>
        public int instruction_cycle { get; set; } = 0;

        /// <summary>
        /// 执行人
        /// </summary>
        public string instruction_mid { get; set; } = string.Empty;
        [NotMapped]
        public List<string> instruction_mids { get { return instruction_mid.Split(',').ToList(); } }

        /// <summary>
        /// 
        /// </summary>
        public int count { get; set; } = 0;

        /// <summary>
        /// 执行日期范围，默认1一直执行(1年)，2自定义执行日期范围
        /// </summary>
        public int date_rang { get; set; } = 0;

        /// <summary>
        /// 
        /// </summary>
        public int endtime { get; set; } = 0;

        /// <summary>
        /// 
        /// </summary>
        public int starttime { get; set; } = 0;

        /// <summary>
        /// 
        /// </summary>
        public int projectid { get; set; }
    }

    public class ResponsePlanItem : TpmEntityBase
    {
        /// <summary>
        /// 1->设备类型共有；2->某设备独有
        /// </summary>
        public int type { get; set; } = 0;

        /// <summary>
        /// _project_machine_type.id
        /// </summary>
        public int typeid { get; set; } = 0;

        /// <summary>
        /// _project_machine.id
        /// </summary>
        public int machineid { get; set; } = 0;

        /// <summary>
        /// 维护检查的内容
        /// </summary>
        public string content { get; set; } = string.Empty;

        /// <summary>
        /// 1->勾选确定型；2->数值记录型
        /// </summary>
        public int value_type { get; set; } = 0;

        /// <summary>
        /// 模式 1->AM(自主执行)；2->PM
        /// </summary>
        public int mode { get; set; } = 0;

        /// <summary>
        /// 数值单位
        /// </summary>
        public string unit { get; set; } = string.Empty;

        /// <summary>
        /// 上限
        /// </summary>
        public string up_limit { get; set; } = string.Empty;

        /// <summary>
        /// 下限
        /// </summary>
        public string lower_limit { get; set; } = string.Empty;

        /// <summary>
        /// 严重度等级1->高；2->中；3->低
        /// </summary>
        public int severity_level { get; set; } = 0;

        /// <summary>
        /// 对应故障失效模式
        /// </summary>
        public string failure_mode { get; set; } = string.Empty;

        /// <summary>
        /// 执行指导书
        /// </summary>
        public string work_instruction_url { get; set; } = string.Empty;

        /// <summary>
        /// 结果样板
        /// </summary>
        public string result_demo_url { get; set; } = string.Empty;

        /// <summary>
        /// 计划用时（分钟）
        /// </summary>
        public int standard_time { get; set; } = 0;

        /// <summary>
        /// 实际停机时间（分钟）
        /// </summary>
        public int actual_standard_time { get; set; } = 0;

        /// <summary>
        /// 合作维修人
        /// </summary>
        public string corepairer { get; set; } = string.Empty;

        /// <summary>
        /// 执行周期（天）
        /// </summary>
        public int instruction_cycle { get; set; } = 0;

        /// <summary>
        /// 创建人
        /// </summary>
        public int create_mid { get; set; } = 0;

        /// <summary>
        /// 创建时间
        /// </summary>
        public int create_time { get; set; } = 0;

        /// <summary>
        /// 备注
        /// </summary>
        public string remark { get; set; } = string.Empty;

        /// <summary>
        /// 执行指导书name
        /// </summary>
        public string work_instruction_name { get; set; } = string.Empty;

        /// <summary>
        /// 
        /// </summary>
        public int projectid { get; set; }

        /// <summary>
        /// 维护工具
        /// </summary>
        public string maintain_tool { get; set; } = string.Empty;

        /// <summary>
        /// 维护备件
        /// </summary>
        public string maintain_sparepart { get; set; } = string.Empty;

        /// <summary>
        /// 命中项
        /// </summary>
        public string hit_item { get; set; } = string.Empty;

        /// <summary>
        /// 维护方法
        /// </summary>
        public string maintain_method { get; set; } = string.Empty;

        public int faulttype { get; set; } = 0;
    }
}
