﻿using System.Collections.Generic;
using System.ComponentModel.DataAnnotations.Schema;
using System.Linq;

namespace Siger.Middlelayer.EsopRepository.Entities
{
    public class siger_project_esop_process_set : EsopEntityBase
    {
        public int process_id { get; set; }

        /// <summary>
        /// 审批人类型：1-指定岗位；2-指定人员
        /// </summary>
        public int approval_usertype { get; set; }

        /// <summary>
        /// 审批人用户组id或者用户id
        /// </summary>
        public string approval_usergroupid { get; set; }

        /// <summary>
        /// 审批类型 1：会审 2：任意
        /// </summary>
        public int approval_type { get; set; }

        /// <summary>
        /// 步骤号
        /// </summary>
        public int step_number { get; set; }




        [NotMapped]
        public List<string> ids { get {
                if (string.IsNullOrEmpty(approval_usergroupid))
                {
                    return new List<string>();
                }
                else
                {
                    return approval_usergroupid.Split(',').Where(f => !string.IsNullOrEmpty(f)).ToList();
                }
            } }
    }
}
