﻿using System.Collections.Generic;
using Siger.Middlelayer.Common.FieldEnum;
using Siger.Middlelayer.EsopRepository.Entities;
using Siger.Middlelayer.EsopRepository.Request;
using Siger.Middlelayer.EsopRepository.Response;
using Siger.Middlelayer.Repository.Paged;

namespace Siger.Middlelayer.EsopRepository.Repositories.Interface
{
    public interface IEsopDocumentCreateRepository : IEsopRepositoryBase<siger_project_esop_document>
    {
        IPagedCollectionResult<ResponseGetEsopDocumentList> GetDocumentPagedList(string starttime, string endtime,
            int status, int type, string keyword, int project_id, int user_id, int page, int pagesize);

        IPagedCollectionResult<ResponseGetEsopDocumentList> GetDocumentAuditPagedList(int user_id, int project_id,
            int page, int pagesize);

        bool AddDocument(RequestAddDocumentCreate request, int projectId, int userId);

        bool AddApprovalHistory(RequestApprovalDocument request, int userId);

        IEnumerable<ResponseGetApprovalList> GetApprovalLists(int doc_id);

        IEnumerable<ResponseGetUnBindDocument> GetDocuments(IEnumerable<int> document_ids);

        IEnumerable<ResponseGetDocumentByType> GetDocumentsByType(int typeId, string name, int projectId);

        EsopApprovalResult ApprovalDocument(IEnumerable<ResponseGetProcessFlow> flows, int document_id, int process_id,
            int ispass, int user_id);

        void ClearApprovalRecords(int document_id);

        IEnumerable<ResponseFileInfo> GetFileUrl(int station, string product, int projectid);


        List<ResponseFileSet> GetEsopFileSet(int productid, int projectid);
    }
}
