﻿using System;
using Siger.Middlelayer.Common.FieldEnum;

namespace Siger.Middlelayer.IMSRepository.Entities
{
    /// <summary>
    /// 刀具刀柄附件表
    /// </summary>
    public class siger_project_ims_tool : IMSEntityBase
    {
        /// <summary>
        /// 名称
        /// </summary>
        public string name { get; set; } = string.Empty;

        /// <summary>
        /// 编号
        /// </summary>
        public string number { get; set; } = string.Empty;

        /// <summary>
        /// 类别id
        /// </summary>
        public int category_id { get; set; }

        /// <summary>
        /// 类别名称
        /// </summary>
        public string category_name { get; set; } = string.Empty;

        /// <summary>
        /// 料号
        /// </summary>
        public string part_no { get; set; } = string.Empty;

        public string image { get; set; }
        
        public string video { get; set; }

        /// <summary>
        /// 刀具当前状态
        /// </summary>
        public ToolStatus tool_status { get; set; }

        public ImsSettingCategory category { get; set; }

        public DateTime create_time { get; set; } = DateTime.Now;

        /// <summary>
        /// 是否修磨 1是 2不是
        /// </summary>
        public int grind { get; set; }

        /// <summary>
        /// 修磨次数
        /// </summary>
        public int grind_times { get; set; }

        /// <summary>
        /// 修磨方式 1自主修磨 2外协修磨
        /// </summary>
        public int grind_type { get; set; }

        /// <summary>
        /// 使用次数
        /// </summary>
        public int use_times { get; set; }

        public int material_id { get; set; }
        /// <summary>
        /// 1需要测试2不需要测试
        /// </summary>
        public int need_test { get; set; }
        /// <summary>
        /// 是否需要检测
        /// </summary>
        public int need_detection { get; set; }

        public string image_name { get; set; }
    }
}
