﻿using Siger.Middlelayer.Common;
using Siger.Middlelayer.Common.Helpers;
using Siger.Middlelayer.Common.ModuleEnum;
using Siger.Middlelayer.QmsRepository.Entities;
using Siger.Middlelayer.QmsRepository.Repositories.Interface;
using Siger.Middlelayer.QmsRepository.Response;
using Siger.Middlelayer.Repository.Paged;
using Siger.Middlelayer.Utility.ImportEntities;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Linq.Expressions;
using System.Text;

namespace Siger.Middlelayer.QmsRepository.Repositories
{
    internal class QmsReworkReferenceRepository : QMSRepositoryBase<siger_qms_rework_reference>, IQmsReworkReferenceRepository
    {
        private readonly ApiQmsDbContext _context;
        public QmsReworkReferenceRepository(ApiQmsDbContext context) : base(context)
        {
            _context = context;
        }

        public IPagedCollectionResult<ReworkReason> GetReworkReasonPagedList(string key, int projectId, int page, int pagesize)
        {
            Expression<Func<ReworkReason, bool>> funtype = f => true;
            var query = from r in _context.siger_qms_rework_reference
                        join t in _context.siger_qms_rework_type on r.ReferType equals t.id
                        where r.projectid == projectId
                        select new ReworkReason
                        {
                             id=r.id,
                             type=r.Type,
                             refer=r.ReferType,
                             referDesc=t.name,
                             reason=r.Remark,
                        };

            if (!string.IsNullOrEmpty(key))
            {
                funtype = f => f.referDesc.Contains(key);
            }

            var total = query.Count(funtype);
            var entities = query.Where(funtype).OrderBy(s=>s.id).Skip((page - 1) * pagesize).Take(pagesize).ToList();
            foreach(var d in entities)
            {
                var typeEnum = (ReworkDataType)d.type;
                d.typeDesc = EnumHelper.GetEnumDesc(typeEnum); 
            }
            return new PagedCollectionResult<ReworkReason>(entities, total);
      
        }

        public CommonImportResult ImportReference(IEnumerable<ImportReworkReason> datas, int projectid)
        {
            var errors = new List<string>();
            var rowIndex = 1;

            var dataArry = new List<siger_qms_rework_reference>();
            foreach(var d in datas)
            {
                var objType = _context.siger_qms_rework_type.FirstOrDefault(f => f.projectid == projectid && f.type==d.Type);
                if (objType==null)
                {
                    errors.Add($"{rowIndex},{(int)CommonEnum.RecordExits}");
                    return new CommonImportResult(0, string.Join(";", errors));
                }
                var obj = _context.siger_qms_rework_reference.FirstOrDefault(f => f.projectid == projectid && f.ReferType == objType.id && f.Remark == d.Reason);
                if (obj!=null)
                {
                    errors.Add($"{rowIndex},{(int)CommonEnum.RecordExits}");
                    return new CommonImportResult(0, string.Join(";", errors));
                }
                dataArry.Add(new siger_qms_rework_reference { 
                  ReferType=objType.id,
                  Remark=d.Reason,
                  Type=d.Type,
                  projectid=projectid,
                  DateTime=DateTime.Now,
                  status=1
                });
            }
            if (errors.Any())
            {
                return new CommonImportResult(0, string.Join(";", errors));
            }
            if (dataArry.Any())
            {
                _context.siger_qms_rework_reference.AddRange(dataArry);
                _context.SaveChanges();
                return new CommonImportResult(1, "1");
            }
            return new CommonImportResult(0, "0");
        }
    }
}
