﻿using NPOI.SS.Formula.Functions;
using Siger.Middlelayer.Common;
using Siger.Middlelayer.QmsRepository.Entities;
using Siger.Middlelayer.QmsRepository.Repositories.Interface;
using Siger.Middlelayer.QmsRepository.Response;
using Siger.Middlelayer.Repository.Paged;
using Siger.Middlelayer.Utility.ImportEntities;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

namespace Siger.Middlelayer.QmsRepository.Repositories
{
    internal class QmscellRepository : QMSRepositoryBase<siger_qms_cell>, IQmscellRepository
    {
        private ApiQmsDbContext _context;
        public QmscellRepository(ApiQmsDbContext context) : base(context)
        {
            _context = context;
        }

        public IPagedCollectionResult<ResponseCellCombox> GetCellComboxPagedList(int projectId, int page, int pagesize)
        {
            var query = from q in _context.siger_qms_cell
                        join cf in _context.siger_qms_cell_cfg on q.cell equals cf.id
                        join ncf in _context.siger_qms_cell_cfg on q.nextcell equals ncf.id into temp
                        from ncfg in temp.DefaultIfEmpty()
                        where q.projectid == projectId
                        select new ResponseCellCombox
                        {
                            id = q.id,
                            Cell = q.cell,
                            CellDesc = cf.cell,
                            NextCell = q.nextcell,
                            NextCellDesc =ncfg==null?"": ncfg.cell
                        };
            var total = query.Count();
            var entities = query.Skip((page - 1) * pagesize).Take(pagesize).ToList();
            return new PagedCollectionResult<ResponseCellCombox>(entities, total);

        }

        public CommonImportResult ImportWorkCell(IEnumerable<ImportWorkCell> datas, int projectid)
        {

            int rowIndex = 0;
            List<string> messages = new List<string>();
            List<siger_qms_cell> entities = new List<siger_qms_cell>();
            foreach (var it in datas)
            {
                rowIndex += 1;
                var cellobj = _context.siger_qms_cell_cfg.FirstOrDefault(f => f.projectid == projectid && f.cell == it.Cell);
                if(cellobj==null)
                {
                    messages.Add($"{rowIndex},{(int)CommonEnum.RecordExits}");
                    return new CommonImportResult(0, string.Join(";", messages));
                }
                var ncellobj = _context.siger_qms_cell_cfg.FirstOrDefault(f => f.projectid == projectid && f.cell == it.NextCell);
                if (ncellobj == null)
                {
                    messages.Add($"{rowIndex},{(int)CommonEnum.RecordExits}");
                    return new CommonImportResult(0, string.Join(";", messages));
                }

                var obj= _context.siger_qms_cell.FirstOrDefault(f => f.projectid == projectid && f.cell == cellobj.id && f.nextcell == ncellobj.id);
                if (obj!=null)
                    messages.Add($"{rowIndex},{(int)CommonEnum.RecordExits}");
                if (messages.Any())
                    return new CommonImportResult(0, string.Join(";", messages));
                entities.Add(new siger_qms_cell { 
                   cell=cellobj.id,
                   nextcell=ncellobj.id,
                   projectid=projectid,
                   status= (int)RowState.Valid,
                });
            }
            try
            {
                _context.siger_qms_cell.AddRange(entities);
                if (_context.SaveChanges() > 0)
                    return new CommonImportResult(1, "1");
                else
                    throw new BadRequestException(CommonEnum.Fail);
            }
            catch
            {
                throw;
            }
        }

        public bool VerifyCellStation(int cellCombox, int section)
        {
            //var qury= from q in _context.siger_qms_cell
            //          join c in _context.siger_qms_cell_cfg on q.cell equals c.id
            //          join n in _context.siger_qms_cell_cfg on q.nextcell equals n.id
            //          select {

            //}
            return true;
        }
    }
}
