﻿namespace Siger.Middlelayer.QmsRepository.Request
{
    public class RequestInspectAnalysis
    {
        public string productcode { get; set; }

        public int line { get; set; }

        public int station { get; set; }

        public string start_time { get; set; }

        public string end_time { get; set; }

        /// <summary>
        /// 图表类型 1 计数控制图 2 不良柏拉图
        /// </summary>
        public string chart_type { get; set; }

        /// <summary>
        /// 图形类型(chart_type=1) 1 不良率控制图 2 不良数控制图
        /// </summary>
        public string graph_type { get; set; }

        /// <summary>
        /// 取点方式(chart_type=1) 1每笔2每天3每周4每月
        /// </summary>
        public string dot_type { get; set; }


        /// <summary>
        /// (chart_type=2)1 所有不良 2 检验类别
        /// </summary>
        public string unhealthy_type { get; set; }

        /// <summary>
        /// (chart_type=2)检验类别
        /// </summary>
        public string category { get; set; }
    }

    public class RequestInspectCounValueAnalysis
    {
        public string productcode { get; set; }

        /// <summary>
        /// 项目id
        /// </summary>
        public string item { get; set; }

        public int line { get; set; }

        public int station { get; set; }

        public string start_time { get; set; }

        public string end_time { get; set; }

        /// <summary>
        /// 图表类型 1 计量值控制图 2 直方图 3 过程能力分析
        /// </summary>
        public int chart_type { get; set; }

        /// <summary>
        /// 图形类型 1 平均数极差控制图 2 单值移动极差控制图
        /// </summary>
        public int graph_type { get; set; }
        
        /// <summary>
        /// 计算水准
        /// </summary>
        public string count_level { get; set; }

    }
}
