﻿using Siger.Middlelayer.Repository.Request;
using System.Collections.Generic;
using System;

namespace Siger.Middlelayer.QmsRepository.Request
{
    public class RequestSensorParameterData : RequestPageBase
    {
        public string sensor_code { get; set; }
        public string name { get; set; }
        public int typeid { get; set; }
        public string factory_label { get; set; }
        public string model { get; set; }
        public string range { get; set; }
        public int station { get; set; }
        public int cycle_unit { get; set; }
        public double cycle { get; set; }
        public int alarm { get; set; }
        public string mid { get; set; }
        public int id { get; set; }

        public string sensor_status { get; set; }
        public string factory_precision { get; set; }
        public string acceptable_precision1 { get; set; }
        public string acceptable_precision2 { get; set; }
        public string acceptable_precision3 { get; set; }
        public string acceptable_precision4 { get; set; }
        public string acceptable_precision5 { get; set; }
        public string mark_place { get; set; }
        public string external_system { get; set; }
        public string bind_manual { get; set; }
        public string validation_manual { get; set; }
        public string standard_procedure1 { get; set; }
        public string standard_procedure2 { get; set; }
        public string temperature { get; set; }
        public string remark { get; set; }
        public string humidity { get; set; }
        public string position { get; set; }
        public List<string> qualities { get; set; }
        public string calibration_source { get; set; }
        public string sensor1 { get; set; }
        public string sensor2 { get; set; }
        public string sensor3 { get; set; }
        public string sensor4 { get; set; }
        public int verification { get; set; }
        public int mark_uid { get; set; }

        /// <summary>
        /// 上一次标定时间
        /// </summary>
        public string marktime { get; set; }
    }

    public class RequestSensorMark : RequestPageBase
    {
        public string lastdtBegin { get; set; }
        public string lastdtEnd { get; set; }
        public string nextdtBegin { get; set; }
        public string nextdtEnd { get; set; }
        public string sensor_code { get; set; }
        public string model { get; set; }
        public int sectionid { get; set; }
        public int mid { get; set; }
        public int typeid { get; set; }
        public int id { get; set; }
        public int status { get; set; }
        public int approvaluser { get; set; }
        public int checkuser { get; set; }

    }

    public class RequestMarkSensor
    {
        public int id { get; set; }
        public string sensor_code { get; set; }
        public string result { get; set; }
        public string remark { get; set; }
        public int checkuser { get; set; }
        public int approvaluser { get; set; }
        public List<RequestSensorFileData> file { get; set; }
        public int appearance { get; set; }
        public int label { get; set; }
        public int checkuser2 { get; set; }
        public string supplier { get; set; }
        public string type { get; set; }
        public List<RequestSensorFileData> history { get; set; }
        public string history_result { get; set; }
        public string token { get; set; }
        public int projectid { get; set; }
        public int uid { get; set; }
    }
    public class RequestApproveSensor
    {
        public List<int> ids { get; set; }
        public string token { get; set; }
        public string result { get; set; }
    }
    public class RequestSensorToken
    {
        public int uid { get; set; }
        public int expirationtime { get; set; }
        public int type { get; set; }
    }
}

