﻿using System;
using System.Collections.Generic;

namespace Siger.Middlelayer.QmsRepository.Response
{
    public class ResponseIncomingMaterial
    {
        public int id { get; set; }
        public int materialid { get; set; }
        public string materialpn { get; set; }
        public string materialname { get; set; }
        public int sectionid { get; set; }
        public string sectionname { get; set; }
        public int supplierid { get; set; }
        public string suppliername { get; set; }
        public string materialspec { get; set; }
        public string batchnumber { get; set; }
        public int totalquantity { get; set; }
        public int randomchecknumber { get; set; }
        public string result { get; set; }
        public int check_mid { get; set; }
        public string check_user { get; set; }
        public string check_time { get; set; }
        public DateTime check_datetime { get; set; }

        public List<UploadFileModel> images = new List<UploadFileModel>();

        public List<UploadFileModel> files = new List<UploadFileModel>();

        public double? max_value { get; set; }

        public string po { get; set; }

        public string date { get; set; }

        public string remark { get; set; }
    }

    public class UploadFileModel
    {
        public string status { get; set; } = "finished";
        public int size { get; set; } = 0;
        public string name { get; set; } = string.Empty;
        public double percentage { get; set; } = 100;
        public long uid { get; set; } = 0;
        public bool showProgress { get; set; } = false;
        public string url { get; set; } = string.Empty;
    }

    public class IncomingMaterialDetails
    {
        public int index { get; set; }

        public int id { get; set; }

        public int itemid { get; set; }

        public string itmename { get; set; }

        public double max_value { get; set; }

        public double min_value { get; set; }

        public string standard { get; set; }

        public string result { get; set; }

        public double? value { get; set; }

        public string sn { get; set; }

        public int checktype { get; set; }

        public double? lowerlimit { get; set; }

        public double? upperlimit { get; set; }

        public string range { get; set; }

        public int valuecategory { get; set; }

        public string item_range { get; set; }
    }

    public class ResponseBadIncomingData
    {
        public ResponseBadIncomingData()
        {
            if (x1 == null)
            {
                x1 = new List<string>();
            }
            if (y1 == null)
            {
                y1 = new List<int>();
            }
            if (y2 == null)
            {
                y2 = new List<int>();
            }
            if (y3 == null)
            {
                y3 = new List<double>();
            }
            if (y4 == null)
            {
                y4 = new List<double>();
            }
            if (data == null)
            {
                data = new List<ResponseBadIncomingDataEx>();
            }
        }
        public List<string> x1 { get; set; }
        public List<int> y1 { get; set; }
        public List<int> y2 { get; set; }
        public List<double> y3 { get; set; }
        public List<double> y4 { get; set; }
        public List<ResponseBadIncomingDataEx> data { get; set; }
        public string name { get; set; }

    }
    public class ResponseBadIncomingDataEx
    {
        public string month { get; set; }
        public int incoming_batch { get; set; }
        public int defect_batch { get; set; }
        public double defect_rate { get; set; }
    }

    public class ResponseCheckIncomingSn
    {
        public int materialid { get; set; }
        public string partno { get; set; }
        public string partname { get; set; }
        public string spec { get; set; }
        public int quantity { get; set; }
        public string batchnumber { get; set; }
    }

    public class ResponseGetUpdateDetails
    {
        public int result { get; set; }

        public List<UploadFileModel> images = new List<UploadFileModel>();

        public List<UploadFileModel> files = new List<UploadFileModel>();

        public List<IncomingMaterialDetails> details = new List<IncomingMaterialDetails>();
    }
}
