﻿using Siger.Middlelayer.QmsRepository.Request;
using System.Collections.Generic;

namespace Siger.Middlelayer.QmsRepository.Response
{
    public class RepsonseInspectStandard
    {
        public int id { get; set; }

        public int productid { get; set; }
        /// <summary>
        /// 产品编号
        /// </summary>
        public string productcode { get; set; }

        public string productname { get; set; }

        /// <summary>
        /// 
        /// </summary>
        public int sectionid { get; set; }

        public string section_value { get; set; }

        /// <summary>
        /// 项次
        /// </summary>
        public int seq { get; set; }

        /// <summary>
        /// 项目
        /// </summary>
        public string item { get; set; }

        /// <summary>
        /// 标准
        /// </summary>
        public string standard { get; set; }

        /// <summary>
        /// 单位
        /// </summary>
        public string unit { get; set; }

        /// <summary>
        /// 最大值
        /// </summary>
        public double max_value { get; set; }

        /// <summary>
        /// 最小值
        /// </summary>
        public double min_value { get; set; }

        /// <summary>
        /// 不良代码
        /// </summary>
        public string unhealthy_code { get; set; }

        /// <summary>
        /// 不良描述
        /// </summary>
        public string unhealthy_desc { get; set; }

        /// <summary>
        /// 维护人
        /// </summary>
        public string update_mid { get; set; }

        /// <summary>
        /// 维护时间
        /// </summary>
        public string update_time { get; set; }

        /// <summary>
        /// 数据类型 1 打钩 2填值
        /// </summary>
        public int value_type { get; set; }

        public int unhealthy_category_id { get; set; }

        public string unhealthy_category_name { get; set; }

        /// <summary>
        /// 不良ID
        /// </summary>
        public int unhealthy_id { get; set; }

        public string unhealthy_name { get; set; }

        public List<int> sectionids { get; set; } = new List<int>();

        public int value_category { get; set; }

        public double range { get; set; }

        public int standard_type { get; set; }

        public string check_type { get; set; }
        public List<int> checktype { get; set; } = new List<int>();

        /// <summary>
        /// 控制上限
        /// </summary>
        public double? ucl { get; set; }
        /// <summary>
        /// 控制下限
        /// </summary>
        public double? lcl { get; set; }

        /// <summary>
        /// 是否触发安灯0不触发 1触发
        /// </summary>
        public int trigger_andon { get; set; }

        public List<RequestOption> data { get; set; } = new List<RequestOption>();

        public string image { get; set; }
    }

    public class RepsonseInspectStandardMaterial
    {
        public int id { get; set; }

        public int materialid { get; set; }
        /// <summary>
        /// 产品编号
        /// </summary>
        public string materialpn { get; set; }

        public string materialname { get; set; }

        public string materialspec { get; set; }

        /// <summary>
        /// 
        /// </summary>
        public int sectionid { get; set; }

        public string section_value { get; set; }

        /// <summary>
        /// 项次
        /// </summary>
        public int seq { get; set; }

        /// <summary>
        /// 项目
        /// </summary>
        public string item { get; set; }

        /// <summary>
        /// 标准
        /// </summary>
        public string standard { get; set; }

        /// <summary>
        /// 单位
        /// </summary>
        public string unit { get; set; }

        /// <summary>
        /// 最大值
        /// </summary>
        public double max_value { get; set; }

        /// <summary>
        /// 最小值
        /// </summary>
        public double min_value { get; set; }

        /// <summary>
        /// 不良代码
        /// </summary>
        public string unhealthy_code { get; set; }

        /// <summary>
        /// 不良描述
        /// </summary>
        public string unhealthy_desc { get; set; }

        /// <summary>
        /// 维护人
        /// </summary>
        public string update_mid { get; set; }

        /// <summary>
        /// 维护时间
        /// </summary>
        public string update_time { get; set; }

        /// <summary>
        /// 数据类型 1 打钩 2填值
        /// </summary>
        public int value_type { get; set; }

        public int unhealthy_category_id { get; set; }

        public string unhealthy_category_name { get; set; }

        /// <summary>
        /// 不良ID
        /// </summary>
        public int unhealthy_id { get; set; }

        public string unhealthy_name { get; set; }

        public List<int> sectionids { get; set; } = new List<int>();

        public int categoryid { get; set; }

        public string categoryname { get; set; }

        public int value_category { get; set; }

        public double range { get; set; }
    }

    public class ResponseIdItem
    {
        public int id { get; set; }

        public string item { get; set; }
    }
    public class ResponseProductItem
    {
        public int productId { get; set; }
        public string productName { get; set; }
    }
    public class ResponseOQCItem
    {
        /// <summary>
        /// 项目ID
        /// </summary>
        public int id { get; set; }
        /// <summary>
        /// 项目
        /// </summary>
        public string item { get; set; }
        /// <summary>
        /// 数据类型 1 打钩 2填值
        /// </summary>
        public int type { get; set; }
        public double min_val { get; set; }
        public double max_val { get; set; }
        /// <summary>
        /// 单位
        /// </summary>
        public string unit { get; set; }
    }
}