﻿using System;
using System.Collections.Generic;
using System.Text;

namespace Siger.Middlelayer.QmsRepository.Response
{
    public class ResponseWasteData
    {
        public int Id { get; set; }
        public int DtsId { get; set; }

        /// <summary>
        /// 工位ID
        /// </summary>
        public int Section { get; set; }
        /// <summary>
        /// 工位名称
        /// </summary>
        public string SectionDesc { get; set; }
        /// <summary>
        /// 通道ID
        /// </summary>
        public int SectionParent { get; set; }
        /// <summary>
        /// 通道名称
        /// </summary>
        public string SectionParentDesc { get; set; }

        /// <summary>
        /// 入库数量
        /// </summary>
        public int Warehorue { get; set; }
        /// <summary>
        /// 增值
        /// </summary>
        public double AddPrice { get; set; }
        /// <summary>
        /// 产品ID
        /// </summary>
        public int ProductId { get; set; }
        /// <summary>
        /// 产品数量
        /// </summary>
        public int Qty { get; set; }
        /// <summary>
        /// 报废时间
        /// </summary>
        public DateTime DateTime { get; set; }
        public int Year { get; set; }
        /// <summary>
        /// 报废时间：月份
        /// </summary>
        public string Month { get; set; }
        public string Date { get; set; }

        public int Item { get; set; }
        /// <summary>
        /// 报废项目
        /// </summary>
        public string ItemDesc { get; set; }
        /// <summary>
        /// 报废原因
        /// </summary>
        public string Cause { get; set; }
        public int Material { get; set; }
        public string MaterialName { get; set; }
        /// <summary>
        /// 物料数量
        /// </summary>
        public int Count { get; set; }


        /// <summary>
        /// 物料单价
        /// </summary>
        public double Price { get; set; }
        public int ReferType { get; set; }
        public string  ReferTypeDesc { get; set; }
        public int Refer { get; set; }
        public string ReferDesc { get; set; }
        public int level_sectionid { get; set; }

    }

    public class ResponseReworkData
    {
        public string ProductName { get; set; }
        public string ProductCode { get; set; }
        public DateTime ReworkTime { get; set; }
        public string SectionName { get; set; }
        public string Reason { get; set; }
        public int Count { get; set; }
        public double Loss { get; set; }
        public string Operator { get; set; }
    }
}
