﻿using Siger.Middlelayer.Common.Helpers;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

namespace Siger.Middlelayer.Repository.Data.Tpm
{
    public class GetListSearchPlan : EntityBase
    {
        public int id { get; set; }

        /// <summary>
        /// 1->设备类型共有；2->某设备独有
        /// </summary>
        public int type { get; set; }

        /// <summary>
        /// _project_machine_type.id
        /// </summary>
        public int typeid { get; set; }

        /// <summary>
        /// _project_machine.id
        /// </summary>
        public int machineid { get; set; }

        /// <summary>
        /// 维护检查的内容
        /// </summary>
        public string content { get; set; }

        /// <summary>
        /// 1->勾选确定型；2->数值记录型
        /// </summary>
        public int value_type { get; set; }

        /// <summary>
        /// 模式 1->AM(自主执行)；2->PM
        /// </summary>
        public int mode { get; set; }

        /// <summary>
        /// 数值单位
        /// </summary>
        public string unit { get; set; }

        /// <summary>
        /// 上限
        /// </summary>
        public string up_limit { get; set; }

        /// <summary>
        /// 下限
        /// </summary>
        public string lower_limit { get; set; }

        /// <summary>
        /// 严重度等级1->高；2->中；3->低
        /// </summary>
        public int severity_level { get; set; }

        /// <summary>
        /// 对应故障失效模式
        /// </summary>
        public string failure_mode { get; set; }

        /// <summary>
        /// 执行指导书
        /// </summary>
        public string work_instruction_url { get; set; }

        /// <summary>
        /// 结果样板
        /// </summary>
        public string result_demo_url { get; set; }

        /// <summary>
        /// 计划用时（分钟）
        /// </summary>
        public int standard_time { get; set; }

        /// <summary>
        /// 执行周期（天）
        /// </summary>
        public int instruction_cycle { get; set; }

        /// <summary>
        /// 创建人
        /// </summary>
        public int create_mid { get; set; }
        public string creator { get; set; }

        /// <summary>
        /// 创建时间
        /// </summary>
        public int create_time { get; set; }

        /// <summary>
        /// 备注
        /// </summary>
        public string remark { get; set; }

        /// <summary>
        /// 执行指导书name
        /// </summary>
        public string work_instruction_name { get; set; }

        public int planid { get; set; }

        public string name { get; set; }

        public string machinetitle { get; set; }

        public string first_instruction_time { get; set; }

        public int date_rang { get; set; }

        public int starttime { get; set; }

        public int endtime { get; set; }

        public int count { get; set; }

        public int department { get; set; }

        public string instruction_mid { get; set; }


        public string stas { get; set; }

        public string station { get; set; }

        public string instruction_cycle1 { get; set; }

        public string date_rang_str { get; set; }


        public int instruction_time { get; set; }

        public string instruction_time_str { get; set; }

        public string sectiontitle { get; set; }

        public int timeid { get; set; }


        public string instruction_mid_str { get; set; }

        public int actual_mid { get; set; }


        public string maintain_tool { get; set; }

        public string maintain_sparepart { get; set; }

        public string hit_item { get; set; }

        public string maintain_method { get; set; }

        public int status { get; set; }

        public int faulttype { get; set; }

        public int actual_standard_time { get; set; }
        /// <summary>
        /// 状态字段4【执行中】3【逾期】2【待执行】1【已完成】
        /// </summary>
        public int state { get; set; }
    }

    public class PlanAppItemList : GetListSearchPlan
    {
        public int information { get; set; }
    }

    public class AllPlan
    {
        public int id { get; set; }

        public string content { get; set; }

        public int standard_time { get; set; }

        public string name { get; set; }
        public List<string> mids { get; set; }

        public string machinetitle { get; set; }

        public int machine_id { get; set; }
        public int severity_level { get; set; }
    }
}