﻿using System;
using System.Collections.Generic;
using System.Runtime.CompilerServices;
using Siger.Middlelayer.Dapper.ResultData;
using System.ComponentModel;
using Siger.Middlelayer.Repository.Data;
using Siger.Middlelayer.Repository.Entities;
using Siger.Middlelayer.Repository.Paged;
using Siger.Middlelayer.Repository.Response;
using Siger.Middlelayer.Share.Models;
using Siger.Middlelayer.Utility.ExcelImport;
using Siger.Middlelayer.Utility.ImportEntities;
using Siger.Middlelayer.CncRepository.Response;

namespace Siger.Middlelayer.Repository.Repositories.Interface
{
    public interface ISigerProjectMachineRepository : IApiConfigRepositoryBase<siger_project_machine>
    {
        IPagedCollectionResult<Machine> GetPagedMachines(int childTypeId, int parentMachinetype, string code, string factory,
            string made_date, int projectId, string machineidarr, IList<int> typeIds, int page, int pagesize);

        MachineInfo GetMachineInfo(int id);

        ResponseGetResponseMachines GetMachines(int id, int projectId);

        CommonImportResult ImportMachines(IEnumerable<MachineList> machines, int mid, int projectid);

        CommonImportResult ImportMachinesSkf(IEnumerable<MachineEntityList> machines, int mid, string ip, int projectid);

        IEnumerable<int> GetLevelSectionMachineIds(int id, int projectid);

        IEnumerable<siger_project_level_section> GetLevelSections(int id, int projectid);

        IEnumerable<MachineTypes> GetMachineTypes(IEnumerable<int> machineIds, int projectId);

        IEnumerable<ResponseKeyValue> GetDictKeyValues(int projectId, string key);

        IEnumerable<MachinSectionInfo> GetMachinSectionInfos(IEnumerable<int> machineIds, int projectId);

        int GetMahcineIdBySection(int sectionId);

        IEnumerable<int> GetMachinIdsBySectionId(int sectionId, int typeId, int projectId);

        IEnumerable<ResponseGetUserCode> GetUserCodes(string keyword, int projectId);

        ResponseIdName GetSectionByMachineId(int machineId, int projectId);

        IEnumerable<MachinStationInfo> GetMachinStationInfos(int projectId);

        IEnumerable<siger_project_level_section> GetLevelSectionsByLevelId(int levelId, int projectId);

        ResponseIdName GetMachineBySectionId(int sectionId, int projectId);

        IEnumerable<int> GetSectionIdsByMahcineIds(IEnumerable<int> machineIds, int projectId);

        IEnumerable<siger_project_level_section> GetSecondLevelSection(int projectid);

        List<int> GetParentLevelSectionIds(int sectionId, int projectId);

        IEnumerable<MachineData> GetLevelSectionMachines(int id, int projectid);

        IEnumerable<MachineData> GetLevelSectionNames(int id, int projectid);

        IEnumerable<MachineData> GetLevelSectionNames(IEnumerable<int> machineIds, int projectid);

        siger_project_level_section GetLevelSection(int id, int projectid);

        siger_project_machine_attribution GetMachineAttributionByMachineId(int machineId);

        IEnumerable<siger_project_level_section> GetParentSelfLevelSections(int parentid, int projectid);

        IEnumerable<siger_project_level_section> GetParentLevelSections(int id, int projectid);

        IEnumerable<int> GetMachineIdsBySectionIds(IEnumerable<int> sectionIds, int projectid);

        IEnumerable<siger_project_level_section> GetLevelSectionsBySectionIds(IEnumerable<int> sectionIds, int projectid);


        IEnumerable<int> GetNCLevelSectionMachineIds(int id, int projectid);

        IEnumerable<MachineData> GetNCLevelSectionNames(int id, int projectid);
        
        int GetSectionByMachine(int id, int projectid);
        IEnumerable<MachineData> GetNCLevelSectionMachines(int id, int projectid);

        IEnumerable<MachinSectionInfo> GetNCMachinSectionInfos(IEnumerable<int> machineIds, int projectId);

        IEnumerable<MachinStationInfo> GetNCMachinStationInfos(int projectId);

        IEnumerable<MachineData> GetNCLevelSectionNames(IEnumerable<int> machineIds, int projectid);

        IEnumerable<int> GetNCMachinIdsBySectionId(int sectionId, int typeId, int projectId,bool dashboardWorkshop = false);

        IEnumerable<siger_project_level_section> GetNCLevelSections(int id, int projectid);

        IEnumerable<int> GetNCMachineIdsBySectionIds(IEnumerable<int> sectionIds, int projectid, bool dashboarSlicedata = false);

        IEnumerable<int> GetNCSectionIdsByMahcineIds(IEnumerable<int> machineIds, int projectId);

        ResponseIdName GetNCMachineBySectionId(int sectionId, int projectId);

        int GetNCMahcineIdBySection(int sectionId);


        string GetLevelSectionTitles(int machineId, int projectid, List<siger_project_level> levels, out int sectionId);

        ResponseGetResponseExtendMachines GetExtendMachines(int id, int projectId);

        ExtendMachineInfo GetExtendMachineInfo(int id);
        IEnumerable<int> GetAttributionMachineIds(int id, int projectid);
        IEnumerable<siger_project_machine> GetAttributionMachineList(int id, int projectid, List<int> attribution);
        IEnumerable<siger_project_machine> GetAttributionMachineList(List<int> sections, int projectid, List<int> attribution);
        IEnumerable<MachinSectionInfo> GetMachineStationInfos(IEnumerable<int> machineIds, int projectId);
        List<MachinLocation> GetMachineLocationForDashboard(List<int> machineids, int projectid);
        List<siger_project_machine> GetMachineEntityBySection(int section, int projectid);

        List<siger_project> GetProjectList();
        List<siger_project_machine> GetMathineTitle(IEnumerable<int> machineIds, int status, int projectid, int category);
        IEnumerable<int> GetOrderByNCMachineIds(IEnumerable<int> sectionIds, int projectid);
        string GetMachineAndSectionName(int machineId, int pid);

        MachinSectionInfo GetSectionMachineByCode(string code,int projectId);
        IEnumerable<CncSliceSate> GetsliceSates(IEnumerable<CncSliceSate> sliceSates, int machineId, int projectid,DateTime start, DateTime end);
        IEnumerable<ResponseClockRecord> GetMachineuser(string machineCode, int projectid);

    }
}
