﻿using System;
using System.Threading.Tasks;
using Microsoft.EntityFrameworkCore;

namespace Siger.Middlelayer.Repository
{
    public abstract class UnitOfWork: IUnitOfWork
    {
        private readonly DbContext _context;

        protected UnitOfWork(DbContext context)
        {
            _context = context;
        }
        
        public int Commit()
        {
            try
            {
               return _context.SaveChanges();
            }
            catch (Exception exception)
            {
                if (exception.InnerException != null)
                {
                    throw exception.InnerException;
                }
                throw;
            }
        }

        public Task<int> CommitAsync()
        {
            try
            {
                return _context.SaveChangesAsync();
            }
            catch (Exception exception)
            {
                if (exception.InnerException != null)
                {
                    throw exception.InnerException;
                }
                throw;
            }
        }
    }
}
