﻿namespace Siger.Middlelayer.TlmRepository.Entities
{
    /// <summary>
    /// 刀具清单表
    /// </summary>
    public class siger_project_toollife_tech_tool : TlmEntityBase
    {
        /// <summary>
        /// 刀位号
        /// </summary>
        public string cutter_number { get; set; }

        /// <summary>
        /// 刀具规格
        /// </summary>
        public int tool_model { get; set; }

        /// <summary>
        /// 刀柄规格
        /// </summary>
        public int handle_model { get; set; }

        /// <summary>
        /// 刃长
        /// </summary>
        public double flute_length { get; set; }

        /// <summary>
        /// 刃数
        /// </summary>
        public int flute_count { get; set; }

        /// <summary>
        /// 首下长
        /// </summary>
        public string down_length { get; set; }

        /// <summary>
        /// 伸出长
        /// </summary>
        public string reach_length { get; set; }

        /// <summary>
        /// 上公差
        /// </summary>
        public string upper_tolerance { get; set; }

        /// <summary>
        /// 下公差
        /// </summary>
        public string down_tolerance { get; set; }

        /// <summary>
        /// 备注
        /// </summary>
        public string remark { get; set; } = string.Empty;

        /// <summary>
        /// 品牌
        /// </summary>
        public string brand { get; set; } = string.Empty;

        /// <summary>
        /// 工艺单id
        /// </summary>
        public int technology_id { get; set; }

        public int material_id { get; set; }

        /// <summary>
        /// 料号
        /// </summary>
        public string part_no { get; set; }

        /// <summary>
        /// 数量
        /// </summary>
        public int quantity { get; set; }

        /// <summary>
        /// 额定寿命
        /// </summary>
        public string rated_life { get; set; }
        /// <summary>
        /// 刀具号
        /// </summary>
        public string tool_code { get; set; }
    }
}
