﻿using System;
using System.Collections.Generic;
using Siger.Middlelayer.Repository.Paged;
using Siger.Middlelayer.TlmRepository.Entities;
using Siger.Middlelayer.TlmRepository.Request;
using Siger.Middlelayer.TlmRepository.Response;

namespace Siger.Middlelayer.TlmRepository.Repositories.Interface
{
    public interface IToolLifeToolInstallRepository : ITlmRepositoryBase<siger_project_toollife_tool_install>
    {
        IPagedCollectionResult<ResponseGetInstallList> GetPagedList(IEnumerable<string> machineCodes, string cutter_number, int page, int pagesize, int projectId, int toexcel, string loadTime = "");
        IEnumerable<ResponseGetInstallStock> GetSupplierUnusualList(string reason, string starttime, string endtime, int projectId);
        IPagedCollectionResult<ResponseToolInstallInfo> GetToolInstallInfo(RequestToolInstallInfo req, int projectId);
        List<ToolLifeConfigData> GetToolLifeConfigData(int pid,int mid);
        IPagedCollectionResult<ResponseToolUseData> GetToolUseData(string code, DateTime startTime, DateTime endTime, int uid, int pid, int page, int pageSize,
            string materialcode = null, string supplier = null, string toolname = null);

    }
}
