﻿using System.Collections.Generic;
using Siger.Middlelayer.Common.FieldEnum;
using Siger.Middlelayer.TlmRepository.Entities;
using Siger.Middlelayer.TlmRepository.Request;
using Siger.Middlelayer.TlmRepository.Response;
using Siger.Middlelayer.Utility.ImportEntities;

namespace Siger.Middlelayer.TlmRepository.Repositories.Interface
{
    public interface IToolLifeToolRepository : ITlmRepositoryBase<siger_project_toollife_tool>
    {
        bool AddToolInfo(RequestAddToolInfo request, int projectId);

        IEnumerable<ToolItemInfo> GetToolList(IEnumerable<int> categoryIds, TlmSettingCategory type,
            int projectid);

        CommonImportResult ImportToolInfos(IEnumerable<ToolInfoList> infos, int projectid, int userId, TlmSettingCategory categoryType);

        IEnumerable<siger_project_toollife_tool> GetToolInfos(IEnumerable<int> categoryIds, string name, TlmSettingCategory type, int projectid);
        IEnumerable<ResponseGetMaterials> GetMaterialListEx(int id, string part_no, string name, int count, int projectid);
    }
}
