using System.ComponentModel.DataAnnotations;

namespace Siger.Middlelayer.ToolRepository.Entities
{
    /// <summary>
    /// siger_project_tool_cutter_location_alarm Entity Model
    /// </summary>   
    public class SigerProjectToolCutterLocationAlarm : ToolEntityBase
    {
        /// <summary>
        /// 
        /// </summary>
        [Key]
        public int id { get; set; }
   
        /// <summary>
        /// 项目ID
        /// </summary>
        public int project_id { get; set; }
   
        /// <summary>
        /// 设备ID
        /// </summary>
        public int machine_id { get; set; }
   
        /// <summary>
        /// 主轴ID（名称，非外键）
        /// </summary>
        public string spindle_name { get; set; }
   
        /// <summary>
        /// 刀位ID（名称，非外键）
        /// </summary>
        public string cutter_location_name { get; set; }
   
        /// <summary>
        /// 报警设备当前运行程序号
        /// </summary>
        public string program_no { get; set; }
   
        /// <summary>
        /// 报警等级
        /// </summary>
        public int alarm_grade { get; set; }
   
        /// <summary>
        /// 报警发送方式 10:微信  20:邮件  30:三色灯
        /// </summary>
        public int send_type { get; set; }
   
        /// <summary>
        /// 报警类型（包络线、趋势线）
        /// </summary>
        public int condition_type { get; set; }
   
        /// <summary>
        /// 报警规则类型
        /// </summary>
        public string condition_params { get; set; }
   
        /// <summary>
        /// 报警文案
        /// </summary>
        public string error_msg { get; set; }
   
        /// <summary>
        /// 生产简述（预留字段，暂无用途）
        /// </summary>
        public int cycle_counter { get; set; }
   
        /// <summary>
        /// 生产步骤号
        /// </summary>
        public int step_number { get; set; }
   
        /// <summary>
        /// 报警图片地址
        /// </summary>
        public string alarm_img { get; set; }
   
        /// <summary>
        /// 报警时间
        /// </summary>
        public int alarm_time { get; set; }
   
        /// <summary>
        /// 创建时间
        /// </summary>
        public int create_time { get; set; }
   
        /// <summary>
        /// 状态 1正常  2已删除
        /// </summary>
        public int status { get; set; }
    }
}
