using System.Collections.Generic;
using System.Threading.Tasks;
using Siger.Middlelayer.Redis.RedisEntities;
using Siger.Middlelayer.Repository.Data;
using Siger.Middlelayer.ToolRepository.Entities;
using Siger.Middlelayer.ToolRepository.Response;

namespace Siger.Middlelayer.ToolRepository.Repositories.Interface
{
    public interface ISigerProjectToolSpindleTrueRepository: IApiToolRepositoryBase<SigerProjectToolSpindleTrue>
    {
        /// <summary>
        /// 豸ǰеĳǷΪӹ
        /// </summary>
        /// <param name="machineId"></param>
        /// <param name="spindleId"></param>
        /// <param name="pn"></param>
        /// <param name="spn"></param>
        /// <returns></returns>
        SigerProjectToolCutterLocationTrue CheckProcessProgramBySpindle(int machineId,int spindleId, string pn, string spn);

        /// <summary>
        ///  ȡسŵϢϢ (ʵʱؼ)
        /// </summary>
        /// <param name="machineId"></param>
        /// <param name="projectId"></param>
        /// <returns></returns>
        ResponseSpindleList GetSpindleListBySection(int machineId, int projectId);
        /// <summary>
        /// 豸ȡµλϢ (ʵʱؼ)
        /// </summary>
        /// <param name="projectId"></param>
        /// <param name="machineId"></param>
        /// <param name="spindleId"></param>
        /// <param name="programNo"></param>
        /// <returns></returns>
        List<ToolCuterlocationInfo> getCutterLocationList(int projectId, int machineId, int spindleId, string programNo);
        List<ResponseMachineSpindle> getMachineSpindels(int machineId);

        ///// <summary>
        ///// ȡбһǱ̣
        ///// </summary>
        ///// <returns></returns>
        //ResponseToolsDashbord GetToolsDashbord(int projectId,int sectionId);
        /// <summary>
        /// ȡ豸ID
        /// </summary>
        /// <param name="projectId"></param>
        /// <param name="sectionId">߲㼶</param>
        /// <returns></returns>
        List<SectionMachine> GetMachine(int projectId, int sectionId);
     
        /// <summary>
        /// ȡλϢ
        /// </summary>
        /// <param name="projectId"></param>
        /// <param name="machineId"></param>
        /// <returns></returns>
        IEnumerable<SigerProjectToolCutterLocationAlarm> GetProjectToolCutterLocationAlarms(int projectId, int machineId);
        /// <summary>
        /// ȡеļӹ
        /// </summary>
        /// <param name="projectId"></param>
        /// <param name="machineId"></param>
        /// <param name="Spindle"></param>
        /// <returns></returns>
        IEnumerable<ResponseProgramlist> GetProcessProgramlist(int projectId, int machineId, int Spindle);


        IEnumerable<ResponseMoniterInfo> GetMonitorData(int projectID, List<CNCEquipmentState> sates);

        IEnumerable<ResponseMoniterInfo> GetToolifeData(int projectID, List<CNCEquipmentState> states);

        IEnumerable<int> GetParentLevelSectionIds(int sectionId, int projectid);

        int GetMachineIdBySectionId(int sectionId, int projectId);

        Task<IEnumerable<SpindleCutterInfo>> GetMonitorData(int projectId, int sectionId);
    }
}