﻿using System.Collections.Generic;
using Siger.Middlelayer.Repository.Data.Tpm;
using Siger.Middlelayer.Repository.Paged;
using Siger.Middlelayer.TpmRepository.Entities;

namespace Siger.Middlelayer.TpmRepository.Repositories.Interface
{
    public interface IPlanItemRepository : ITpmRepositoryBase<siger_project_plan_item>
    {
        IEnumerable<GetListPlanItem> GetOnePlanItem(int planId, int projectid);

        IPagedCollectionResult<GetListSearchPlan> GetPagedlist(int projectId, int page, int pagesize);

        IEnumerable<GetAppPlan> GetPlanListByMid(int nowtime, List<int> machineIDArr, int projectId, int userId);

        /// <summary>
        /// 兼容被禁用的已执行记录
        /// </summary>
        /// <param name="endTime"></param>
        /// <param name="machineIDArr"></param>
        /// <param name="projectId"></param>
        /// <param name="userId"></param>
        /// <returns></returns>
        IEnumerable<GetAppPlan> GetPlanHistoryListByMid(int endTime, List<int> machineIDArr, int projectId, int userId);

        IEnumerable<GetAppPlan> GetPlanListByMachineID(int nowtime, int machineID, int projectId, int userId);

        /// <summary>
        /// 兼容被禁用的已执行记录
        /// </summary>
        /// <param name="Time"></param>
        /// <param name="machineID"></param>
        /// <param name="projectId"></param>
        /// <param name="userId"></param>
        /// <returns></returns>
        IEnumerable<GetAppPlans> GetPlanHistory(int Time, int machineID, int projectId, int userId);

        int GetPlanIdMax();

        int GetItemIdMax();

        int GetTimeIdMax();
        IEnumerable<GetAppPlan> GetMachinePlans(int nowtime, List<int> machineIDArr, int projectId, int userId);
        IEnumerable<GetAppPlan> GetPlanHistoryListEx(int endTime, List<int> machineIDArr, int projectId, int userId);
    }
}
