﻿
using Siger.Middlelayer.Common.ModuleEnum;
using Siger.Middlelayer.Repository.Paged;
using Siger.Middlelayer.TpmRepository.Entities;
using Siger.Middlelayer.TpmRepository.Request;
using Siger.Middlelayer.TpmRepository.Response;
using System;
using System.Collections.Generic;

namespace Siger.Middlelayer.TpmRepository.Repositories.Interface
{
    /// <summary>
	/// ISigerAndonExpectionTypeRepository
	/// </summary>
    public interface ISigerAndonInfoRepository : ITpmRepositoryBase<siger_andon_info>
    {
        IPagedCollectionResult<ResponseAndon> GetData(RequestAndon condition, int projectid);
        ResponseAndonInfoByMachine GetCostTimeByMachineid(RequestAndon condition, int projectid);
        int GetCountByType(AndonState state, int projectid);
        string WorkOrderGenerator(int projectid);
        List<ResponseAndonGroupCount> GetAndonGroupCount(int project_id, long start, long end);
        List<GetAndonDashboradDetail> GetAndonDashboradDetail(int project_id, long start, long end);
        bool HandleAndon(RequestHandleAndon req, int pid, int cid,int uid);
        List<siger_project_auto_calculation_data_ttlEx> GetOee(DateTime start, DateTime end, List<int>sections);

        /// <summary>
        /// 安灯完成记录
        /// </summary>
        /// <param name="project_id"></param>
        /// <param name="start"></param>
        /// <param name="end"></param>
        /// <param name="status"></param>
        /// <returns></returns>
        IEnumerable<ResponseAndonDetials> AndonDetials(int project_id, long start, long end,int status);
    }
}
