﻿using Siger.Middlelayer.TpmRepository.Entities;
using System;
using System.Collections.Generic;
using System.Text;
using Siger.Middlelayer.Repository.Paged;
using Siger.Middlelayer.TpmRepository.Request;
using Siger.Middlelayer.TpmRepository.Response;

namespace Siger.Middlelayer.TpmRepository.Repositories.Interface
{
    public interface ISparepartAuditRepository : ITpmRepositoryBase<siger_project_sparepart_audit>
    {
        IPagedCollectionResult<GetPagedAuditSparepartList> GetAuditPagedList(int sectionId, List<int> machineIds,string code,
            int approvalstatus, int category, int projectId, int page, int pagesize);

        IEnumerable<GetAuditSparepartList> GetAuditSparepartList(int auditId);

        int AddPrepareSpareparts(RequestSubmitSpareparts request, int project_id, int user_id,
            bool need_audit);

        int AddPlanPrepareSpareparts(Dictionary<int, int> sps, int planitemId, int project_id, int user_id,
            bool need_audit);

        int AddReplcaeSpareparts(RequestSubmitPrepare request, int userid, int auditId);

        /// <summary>
        /// 备件替换
        /// </summary>
        /// <param name="sectionId"></param>
        /// <param name="machineIds"></param>
        /// <param name="code"></param>
        /// <param name="approvalstatus"></param>
        /// <param name="projectId"></param>
        /// <param name="page"></param>
        /// <param name="pagesize"></param>
        /// <returns></returns>
        IPagedCollectionResult<GetPagedAuditSparepartList> GetReplcaePagedList(int sectionId, List<int> machineIds, string code, int approvalstatus, int projectId, int page, int pagesize);

        IPagedCollectionResult<GetPagedAuditSparepartList> GetRepairPagedList(string code, string sparepart, int repair_category, int status, int projectId, int page, int pagesize, int toexcel);

        siger_project_sparepart_audit_detail GetAuditDetail(int id);

        int UpdateAuditDetail(RequestReplaceSparepart request, int userId);

        int UpdateAuditDetailById(string ids);
    }
}
