﻿using Siger.Middlelayer.Repository.Entities;
using System.Collections.Generic;

namespace Siger.Middlelayer.TpmRepository.Response
{
    public class ResponseAndon
    {
        public ResponseAndon()
        {
        }
        public int id { get; set; }
        public int status { get; set; }
        public int expection_type { get; set; }
        public string expection1 { get; set; } = "";
        public string expection2 { get; set; } = "";
        public string expection3 { get; set; } = "";
        public int usergroup { get; set; }
        public string usergroup_name { get; set; } = "";
        public long create_time { get; set; }
        public int creator { get; set; }
        public string creator_name { get; set; }
        public int handler { get; set; }
        public string handler_name { get; set; }
        public long handle_time { get; set; }
        public long complete_time { get; set; }
        public long abnormal_time { get; set; }
        public int machine { get; set; }
        public int station { get; set; }
        public string machine_name { get; set; }
        public string station_name { get; set; }
        public string process_code { get; set; }
        public int projectid { get; set; }
        public int is_shutdown { get; set; }
        public long approve_time { get; set; }
        public string andon_cost_time { get; set; }
        public string handle_cost_time { get; set; }
        public long cost_time { get; set; }
        public string unresponse_time { get; set; }
        public string unhandle_time { get; set; }
        public string unfinish_time { get; set; }
        public string untrigger_time { get; set; }
        public string work_order { get; set; }
        public string remark { get; set; }

        /// <summary>
        /// 报警原因
        /// </summary>
        public string reason { get; set; } = "";
        /// <summary>
        /// 是否纳入oee计算
        /// </summary>
        public int is_caloee { get; set; } = 1;

        /// <summary>
        /// 是否跳安灯流程
        /// </summary>
        public int is_passprocess { get; set; } = 0;
        public string product_code { get; set; } = "";
        public string product_name { get; set; } = "";
        public string approver_name { get; set; } = "";
        public string completer_name { get; set; } = "";
    }
    public class ResponseAndonInfoByMachine
    {
        public int andon_count { get; set; }
        public string cost_time { get; set; }
        public List<ResponseAndon> data { get; set; }
    }


    public class ResponseAndonStateCount
    {
        public int normal { get; set; } = 0;
        public int abnormal { get; set; } = 0;
        public int andon { get; set; } = 0;
        public List<ResponseAndonStateData> state { get; set; }

    }
    public class ResponseAndonStateData
    {
        public ResponseAndonStateData()
        {
            if (machine == null)
            {
                machine = new List<ResponseAndonState>();
            }
        }
        public string line { get; set; }

        public List<ResponseAndonState> machine { get; set; }
    }
    public class ResponseAndonState
    {
        public string name { get; set; }
        public string station { get; set; }
        public int station_value { get; set; }
        public int state { get; set; }
        public int id { get; set; }
    }

    public class ResponseAndonGroupCount
    {
        public string group_name { get; set; }
        public int group_id { get; set; }
        public int wait_count { get; set; }
        public int unhandle_count { get; set; }
        public int handling_count { get; set; }

    }


    public class GetAndonDashboradDetail
    {
        public string order { get; set; }
        public long create_time { get; set; }
        public string location { get; set; }
        public int location_value { get; set; }
        public string expection { get; set; }
        public int expection_value { get; set; }
        public int parent_expection_value { get; set; }
        public long cost_time { get; set; }
        public int status_value { get; set; }
        public string status { get; set; }
        public int handler_value { get; set; }
        public string handler { get; set; }
        public string group { get; set; }
        public int group_value { get; set; }
        public int errorlevel { get; set; }

    }

    public class ResponseAndonDetials
    {
        public int id { get; set; }
        /// <summary>
        /// 异常类型部门
        /// </summary>
        public int section { get; set; }
        /// <summary>
        /// 异常类型部门名称
        /// </summary>
        public string sectionTitle { get; set; }
        /// <summary>
        /// 异常类型 岗位ID
        /// </summary>
        public int  station { get; set; }
        /// <summary>
        /// 异常类型 岗位名称
        /// </summary>
        public string stationTitle { get; set; }

        /// <summary>
        /// 创建
        /// </summary>
        public int creater { get; set; }
        public string username { get; set; }
        /// <summary>
        /// 处理人
        /// </summary>
        public int hanlder { get; set; }
        /// <summary>
        ///  解除人
        /// </summary>
        public string complater { get; set; }
        /// <summary>
        /// 复线人
        /// </summary>
        public string approver { get; set; }

        public int expectype { get; set; }
        public long create_time { get; set; }
        public long handle_time { get; set; }
        public long complete_time { get; set; }
      
        public long approve_time { get; set; }
        public int status { get; set; }
             
    }
}
