﻿using System.Collections.Generic;
using System.Linq;

namespace Siger.Middlelayer.TpmRepository.Response
{
    public class ResponseGetRepairList
    {
        public int id { get; set; }

        public string station { get; set; } = string.Empty;

        public int machineId { get; set; }

        public string location { get; set; } = string.Empty;

        public string station_name { get; set; }

        /// <summary>
        /// 是否停机
        /// </summary>
        public int offlinestatus { get; set; }

        public string faulttype { get; set; }

        /// <summary>
        /// 失效模式
        /// </summary>
        public string faultcontent { get; set; }

        public string images { get; set; }

        public string remark { get; set; }

        /// <summary>
        /// 工单状态
        /// </summary>
        public int status { get; set; }

        /// <summary>
        /// 故障描述
        /// </summary>
        public string fault_description { get; set; }

        public string repair_process { get; set; }

        public string real_faultid_desc { get; set; }

        public string sparepartid { get; set; }

        public int createtime { get; set; }

        public string createtimeformat { get; set; }

        /// <summary>
        /// 维修用时（分钟）
        /// </summary>
        public double repairtime { get; set; }

        /// <summary>
        /// 总时间（分钟）
        /// </summary>
        public double totaltime { get; set; }

        /// <summary>
        /// 维修人
        /// </summary>
        public string add_repairmid_name { get; set; }

        public string fault_desc_img { get; set; }

        public int takemid { get; set; }
        public int signmid { get; set; }

        public double taketime { get; set; }

        public int checkmid { get; set; }

        public int checktime { get; set; }

        public int signtime { get; set; }

        public string sparepart { get; set; }

        public int fault_id { get; set; }

        public int faulttype_id { get; set; }

        public string repair_remark { get; set; }

        /// <summary>
        /// 维修完成时间
        /// </summary>
        public int completetime { get; set; }

        public int completemid { get; set; }

        public int repairmid { get; set; }

        public int cost { get; set; }

        public int fault_description_id { get; set; }

        public string add_repairmid { get; set; }

        public int add_repairmid_sectionid { get; set; }

        public int andontype { get; set; }

        public string andontypename { get; set; }
        public string work_order { get; set; }
        public string creator { get; set; }
        public int mid { get; set; }
        public List<string> mids
        {
            get
            {
                var ret = add_repairmid.Split(',').ToList();
                if (completemid != 0 && ret.Any(f => f != completemid.ToString()))
                {
                    ret.Add(completemid.ToString());
                }
                return ret;
            }
        }
        public double time1 { get; set; }
        public string user1 { get; set; }

        public double time2 { get; set; }
        public string user2 { get; set; }

        public double time3 { get; set; }
        public string user3 { get; set; }

        public double time4 { get; set; }
        public string user4 { get; set; }

        public double time5 { get; set; }
        public string user5 { get; set; }

        public double time6 { get; set; }
        public string user6 { get; set; }

        public int work_type { get; set; }
    }

    public class ResponseGetRepairInfo
    {
        public int id { get; set; }

        public int machineId { get; set; }

        /// <summary>
        /// 是否停机
        /// </summary>
        public int offlinestatus { get; set; }

        public int faultlist_id { get; set; }

        /// <summary>
        /// 失效模式
        /// </summary>
        public int faultcontent_id { get; set; }

        public string images { get; set; }

        public string remark { get; set; }

        /// <summary>
        /// 工单状态
        /// </summary>
        public int status { get; set; }

        /// <summary>
        /// 故障描述
        /// </summary>
        public string fault_description { get; set; }

        public string repair_process { get; set; }

        public string real_faultid_desc { get; set; }

        public string sparepartid { get; set; }

        public int createtime { get; set; }

        /// <summary>
        /// 维修用时（分钟）
        /// </summary>
        public double repairtime { get; set; }

        /// <summary>
        /// 维修人
        /// </summary>
        public string add_repairmid_name { get; set; }

        public string fault_desc_img { get; set; }

        public double taketime { get; set; }

        public int checktime { get; set; }

        public int signtime { get; set; }

        public string add_repairmid { get; set; }

        public int machinetype_id { get; set; }

        public int mid { get; set; }

        public int signmid { get; set; }

        public int checkmid { get; set; }

        public string sparepartout { get; set; }

        public Dictionary<int, string> sparepartarr { get; set; }

        public string repair_remark { get; set; }
    }
}
