/*
 Navicat Premium Data Transfer

 Source Server         : 172.8.10.113(mysql8.0)
 Source Server Type    : MySQL
 Source Server Version : 80020
 Source Host           : 172.8.10.113:3306
 Source Schema         : siger_changling

 Target Server Type    : MySQL
 Target Server Version : 80020
 File Encoding         : 65001

 Date: 04/11/2020 16:20:26
*/

SET NAMES utf8mb4;
SET FOREIGN_KEY_CHECKS = 0;

-- ----------------------------
-- Table structure for siger_project_ims_cabinet_config
-- ----------------------------
DROP TABLE IF EXISTS `siger_project_ims_cabinet_config`;
CREATE TABLE `siger_project_ims_cabinet_config`  (
  `id` int(0) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `suppliercode` varchar(100) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `suppliername` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `cabinetcode` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  `pickapi` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `inventoryapi` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `status` int(0) NULL DEFAULT 1,
  `project_id` int(0) NULL DEFAULT NULL,
  PRIMARY KEY (`id`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8 COLLATE = utf8_general_ci ROW_FORMAT = Dynamic;

-- ----------------------------
-- Table structure for siger_project_ims_cabinet_receive
-- ----------------------------
DROP TABLE IF EXISTS `siger_project_ims_cabinet_receive`;
CREATE TABLE `siger_project_ims_cabinet_receive`  (
  `id` int(0) NOT NULL AUTO_INCREMENT,
  `billcode` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '单号',
  `usercode` varchar(20) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '工号',
  `cabinetcode` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '柜编号',
  `transtime` datetime(0) NULL DEFAULT NULL COMMENT '领用时间',
  `type` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '领料类型',
  `settletime` datetime(0) NULL DEFAULT NULL COMMENT '结算时间',
  `uid` int(0) NULL DEFAULT NULL COMMENT '结算人',
  `status` int(0) NULL DEFAULT NULL COMMENT '状态',
  `project_id` int(0) NULL DEFAULT NULL,
  PRIMARY KEY (`id`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8 COLLATE = utf8_general_ci ROW_FORMAT = Dynamic;

-- ----------------------------
-- Table structure for siger_project_ims_cabinet_receive_detail
-- ----------------------------
DROP TABLE IF EXISTS `siger_project_ims_cabinet_receive_detail`;
CREATE TABLE `siger_project_ims_cabinet_receive_detail`  (
  `id` int(0) NOT NULL AUTO_INCREMENT,
  `inventoryid` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '料号',
  `name` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '品名',
  `count` int(0) NULL DEFAULT NULL COMMENT '数量',
  `type` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '规格',
  `mid` int(0) NULL DEFAULT NULL COMMENT '主表Id',
  `status` int(0) NULL DEFAULT 1 COMMENT '状态',
  `project_id` int(0) NULL DEFAULT NULL,
  `price` double(10, 2) NULL DEFAULT NULL,
  `supplier` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  PRIMARY KEY (`id`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8 COLLATE = utf8_general_ci ROW_FORMAT = Dynamic;

-- ----------------------------
-- Table structure for siger_project_ims_category
-- ----------------------------
DROP TABLE IF EXISTS `siger_project_ims_category`;
CREATE TABLE `siger_project_ims_category`  (
  `id` int(0) NOT NULL AUTO_INCREMENT,
  `name` varchar(45) CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci NOT NULL COMMENT '类别名称',
  `code` varchar(45) CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci NOT NULL,
  `parent` int(0) NOT NULL COMMENT '父级id',
  `project_id` int(0) NOT NULL COMMENT '项目id',
  `status` int(0) NOT NULL COMMENT '是否有效',
  `category` int(0) NOT NULL COMMENT '1: 刀具 2：刀柄 3：附件',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8mb4 COLLATE = utf8mb4_0900_ai_ci COMMENT = '刀具刀柄附件类型表' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Table structure for siger_project_ims_category_parameter
-- ----------------------------
DROP TABLE IF EXISTS `siger_project_ims_category_parameter`;
CREATE TABLE `siger_project_ims_category_parameter`  (
  `id` int(0) NOT NULL AUTO_INCREMENT,
  `category_id` int(0) NOT NULL COMMENT '类别id',
  `parameter_id` int(0) NOT NULL COMMENT '参数id',
  `parameter_category` varchar(45) CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci NOT NULL,
  `project_id` int(0) NOT NULL,
  `status` int(0) NOT NULL,
  PRIMARY KEY (`id`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8mb4 COLLATE = utf8mb4_0900_ai_ci COMMENT = '刀具刀柄附件参数表' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Table structure for siger_project_ims_detection
-- ----------------------------
DROP TABLE IF EXISTS `siger_project_ims_detection`;
CREATE TABLE `siger_project_ims_detection`  (
  `id` int(0) NOT NULL AUTO_INCREMENT,
  `projectid` int(0) NULL DEFAULT NULL,
  `status` int(0) NULL DEFAULT NULL,
  `creator` int(0) NULL DEFAULT NULL,
  `editor` int(0) NULL DEFAULT NULL,
  `create_time` datetime(0) NULL DEFAULT NULL,
  `edit_time` timestamp(0) NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP(0),
  `seq` varchar(100) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT '' COMMENT '检测编号',
  `type` varchar(100) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT '' COMMENT '检测类型',
  `tools` varchar(100) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT '' COMMENT '检测工具',
  `standard_values` varchar(100) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT '',
  `max` double(12, 6) NULL DEFAULT NULL COMMENT '上限',
  `mini` double(12, 6) NULL DEFAULT NULL COMMENT '下限',
  `tool_id` int(0) NULL DEFAULT NULL COMMENT '刀具编号',
  `tool_type` int(0) NULL DEFAULT 0 COMMENT '配置类型1刀具2刀柄3附件',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8 COLLATE = utf8_general_ci ROW_FORMAT = Dynamic;

-- ----------------------------
-- Table structure for siger_project_ims_detection_detail
-- ----------------------------
DROP TABLE IF EXISTS `siger_project_ims_detection_detail`;
CREATE TABLE `siger_project_ims_detection_detail`  (
  `id` int(0) NOT NULL AUTO_INCREMENT,
  `projectid` int(0) NULL DEFAULT NULL,
  `status` int(0) NULL DEFAULT NULL,
  `creator` int(0) NULL DEFAULT NULL,
  `editor` int(0) NULL DEFAULT NULL,
  `create_time` datetime(0) NULL DEFAULT NULL,
  `edit_time` timestamp(0) NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP(0),
  `order_number` varchar(100) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '检测单号',
  `seq` varchar(100) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT '' COMMENT '检测编号',
  `type` varchar(100) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT '' COMMENT '检测类型',
  `tools` varchar(100) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT '' COMMENT '检测工具',
  `standard_values` varchar(100) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT '',
  `max` double(12, 6) NULL DEFAULT NULL COMMENT '上限',
  `mini` double(12, 6) NULL DEFAULT NULL COMMENT '下限',
  `tool_id` int(0) NULL DEFAULT NULL COMMENT '刀具编号',
  `actual_value` varchar(100) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT '' COMMENT '检测值',
  `result` int(0) NULL DEFAULT 1 COMMENT '1合格2不合格',
  `tool_type` int(0) NULL DEFAULT 0 COMMENT '配置类型1刀具2刀柄3附件',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8 COLLATE = utf8_general_ci ROW_FORMAT = Dynamic;

-- ----------------------------
-- Table structure for siger_project_ims_detection_record
-- ----------------------------
DROP TABLE IF EXISTS `siger_project_ims_detection_record`;
CREATE TABLE `siger_project_ims_detection_record`  (
  `id` int(0) NOT NULL AUTO_INCREMENT,
  `projectid` int(0) NULL DEFAULT NULL,
  `status` int(0) NULL DEFAULT NULL,
  `creator` int(0) NULL DEFAULT NULL,
  `editor` int(0) NULL DEFAULT NULL,
  `create_time` datetime(0) NULL DEFAULT NULL,
  `edit_time` timestamp(0) NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP(0),
  `tool_id` int(0) NULL DEFAULT NULL COMMENT '刀具编号',
  `state` int(0) NULL DEFAULT 1 COMMENT '状态1待检测2检测完成',
  `order_number` varchar(100) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '检测单号',
  `result` int(0) NULL DEFAULT 2 COMMENT '1合格2不合格',
  `tool_type` int(0) NULL DEFAULT 0 COMMENT '配置类型1刀具2刀柄3附件',
  `inspect_time` bigint(0) NULL DEFAULT 0 COMMENT '检测时间',
  `inspector` int(0) NULL DEFAULT 0 COMMENT '检测人',
  `stock_id` int(0) NULL DEFAULT 0 COMMENT '库存id',
  `serial_number` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT '' COMMENT 'wms_stock序号',
  `manage_model` int(0) NULL DEFAULT 1 COMMENT '物料管理类型',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8 COLLATE = utf8_general_ci ROW_FORMAT = Dynamic;

-- ----------------------------
-- Table structure for siger_project_ims_detection_return
-- ----------------------------
DROP TABLE IF EXISTS `siger_project_ims_detection_return`;
CREATE TABLE `siger_project_ims_detection_return`  (
  `id` int(0) NOT NULL AUTO_INCREMENT,
  `projectid` int(0) NULL DEFAULT NULL,
  `status` int(0) NULL DEFAULT NULL,
  `creator` int(0) NULL DEFAULT NULL,
  `editor` int(0) NULL DEFAULT NULL,
  `create_time` datetime(0) NULL DEFAULT NULL,
  `edit_time` timestamp(0) NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP(0),
  `order_number` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT '' COMMENT '检测单号',
  `reason` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT '' COMMENT '退货原因',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8 COLLATE = utf8_general_ci ROW_FORMAT = Dynamic;

-- ----------------------------
-- Table structure for siger_project_ims_expection
-- ----------------------------
DROP TABLE IF EXISTS `siger_project_ims_expection`;
CREATE TABLE `siger_project_ims_expection`  (
  `id` int(0) NOT NULL AUTO_INCREMENT,
  `projectid` int(0) NULL DEFAULT NULL,
  `status` int(0) NULL DEFAULT NULL,
  `creator` int(0) NULL DEFAULT NULL,
  `editor` int(0) NULL DEFAULT NULL,
  `create_time` datetime(0) NULL DEFAULT NULL,
  `edit_time` datetime(0) NULL DEFAULT NULL,
  `datetime` bigint(0) NULL DEFAULT 0 COMMENT '日期',
  `changer` int(0) NULL DEFAULT 0 COMMENT '换刀人',
  `blank_code` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT '' COMMENT '毛坯批号',
  `jig_location` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT '' COMMENT '夹具位置',
  `coolant_temperature` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT '' COMMENT '冷却液温度',
  `defect_location` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT '' COMMENT '缺陷位置',
  `reason` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT '' COMMENT '可能原因',
  `shift` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT '' COMMENT '班次',
  `product_model` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT '' COMMENT '产品型号',
  `machine_id` int(0) NULL DEFAULT 0 COMMENT '设备id',
  `coolant_concentration` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT '' COMMENT '冷却液浓度',
  `tool_number` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '刀具号',
  `ims_rest` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT '' COMMENT '刀具剩余寿命',
  `standard_size` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT '' COMMENT '标准尺寸',
  `other_question` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT '' COMMENT '其他问题',
  `production_batch_number` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT '' COMMENT '生产批号',
  `jig_tower` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT '' COMMENT '夹具塔号',
  `coolant_pressure` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT '' COMMENT '冷却液压力',
  `tool_location` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT '' COMMENT '刀位主轴编号',
  `detective_parts_count` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT '' COMMENT '缺陷零件数',
  `actual_size` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT '' COMMENT '实际尺寸',
  `tool_batch_number` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT '' COMMENT '刀具批次',
  `repair_mold_count` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT '' COMMENT '修模次数',
  `dynamic_balance_result` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT '' COMMENT '动平衡结果',
  `technical_reason` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT '' COMMENT '技术员原因',
  `measured_size` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT '' COMMENT '实测尺寸',
  `order_number` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT '' COMMENT '异常问题单号',
  `tool_standard_life` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT '' COMMENT '刀具标准寿命',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8 COLLATE = utf8_general_ci ROW_FORMAT = Dynamic;

-- ----------------------------
-- Table structure for siger_project_ims_package
-- ----------------------------
DROP TABLE IF EXISTS `siger_project_ims_package`;
CREATE TABLE `siger_project_ims_package`  (
  `id` int(0) NOT NULL AUTO_INCREMENT,
  `assemble_code` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci NOT NULL DEFAULT '' COMMENT '组装的刀柄编号',
  `code` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci NOT NULL DEFAULT '' COMMENT '系列好或者序号',
  `location` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci NOT NULL DEFAULT '' COMMENT '位置',
  `project_id` int(0) NULL DEFAULT NULL,
  `status` int(0) NOT NULL,
  `confirm_status` int(0) NOT NULL COMMENT '0：保存 1：组装完成',
  `create_time` datetime(0) NOT NULL COMMENT '创建时间',
  `create_id` int(0) NOT NULL COMMENT '创建人',
  `measure_status` int(0) NOT NULL DEFAULT 0 COMMENT '刀具测量状态',
  `actual_length` double NULL DEFAULT NULL COMMENT '实际刀长',
  `actual_diameter` double(255, 0) NULL DEFAULT NULL COMMENT '实际直径',
  `boom_code` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci NULL DEFAULT '' COMMENT 'boom刀具号',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8mb4 COLLATE = utf8mb4_0900_ai_ci COMMENT = '刀具组装' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Table structure for siger_project_ims_storage_platform
-- ----------------------------
DROP TABLE IF EXISTS `siger_project_ims_storage_platform`;
CREATE TABLE `siger_project_ims_storage_platform`  (
  `id` int(0) NOT NULL AUTO_INCREMENT,
  `storage_id` int(0) NOT NULL DEFAULT 0 COMMENT '柜子Id',
  `platform` varchar(40) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT '' COMMENT '称台名称 ',
  `name` varchar(100) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT '' COMMENT '物料名称',
  `code` varchar(100) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT '' COMMENT '物料编号',
  `weight` double NULL DEFAULT 0 COMMENT '物料重量',
  `supplier` varchar(100) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT '' COMMENT '供应商',
  `min` double NULL DEFAULT NULL COMMENT '下限',
  `max` double NULL DEFAULT NULL COMMENT '上限',
  `full_count` int(0) NULL DEFAULT 0 COMMENT '满箱数量',
  `peeling_weight` double NULL DEFAULT NULL COMMENT '去皮重量',
  `box_count` int(0) NOT NULL DEFAULT 0 COMMENT '箱子个数',
  `project_id` int(0) NULL DEFAULT 0,
  `status` int(0) NULL DEFAULT NULL,
  `category` int(0) NOT NULL DEFAULT 1 COMMENT '1:刀具领用 2：刀具回收',
  `number` varchar(4) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT '' COMMENT '编号',
  `current_count` int(0) NOT NULL DEFAULT 0 COMMENT '当前物料个数',
  `image_name` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT '',
  `image_content` mediumblob NULL,
  PRIMARY KEY (`id`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8 COLLATE = utf8_general_ci ROW_FORMAT = Dynamic;

-- ----------------------------
-- Table structure for siger_project_ims_tech_tool
-- ----------------------------
DROP TABLE IF EXISTS `siger_project_ims_tech_tool`;
CREATE TABLE `siger_project_ims_tech_tool`  (
  `id` int(0) NOT NULL AUTO_INCREMENT,
  `technology_id` int(0) NOT NULL DEFAULT 0 COMMENT '工艺单Id',
  `cutter_number` varchar(45) CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci NOT NULL COMMENT '刀位号',
  `tool_model` int(0) NOT NULL COMMENT '刀具规格',
  `handle_model` int(0) NOT NULL COMMENT '刀柄规格',
  `flute_length` double NULL DEFAULT NULL,
  `flute_count` int(0) NULL DEFAULT NULL COMMENT '刃数',
  `down_length` varchar(200) CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci NULL DEFAULT NULL,
  `reach_length` varchar(200) CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci NULL DEFAULT '',
  `upper_tolerance` varchar(200) CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci NULL DEFAULT '',
  `down_tolerance` varchar(200) CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci NULL DEFAULT '',
  `remark` varchar(200) CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci NULL DEFAULT NULL COMMENT '备注',
  `project_id` int(0) NOT NULL,
  `status` int(0) NOT NULL,
  `brand` varchar(45) CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci NULL DEFAULT NULL COMMENT '品牌',
  `quantity` int(0) NOT NULL DEFAULT 0 COMMENT '数量',
  `part_no` varchar(45) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT '' COMMENT '料号',
  `rated_life` varchar(200) CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci NULL DEFAULT '',
  `material_id` int(0) NOT NULL DEFAULT 0,
  `tool_code` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci NULL DEFAULT '' COMMENT '刀具号',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8mb4 COLLATE = utf8mb4_0900_ai_ci COMMENT = '刀具清单表' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Table structure for siger_project_ims_technology
-- ----------------------------
DROP TABLE IF EXISTS `siger_project_ims_technology`;
CREATE TABLE `siger_project_ims_technology`  (
  `id` int(0) NOT NULL AUTO_INCREMENT,
  `product_id` int(0) NOT NULL COMMENT '产品id',
  `machine_type` int(0) NOT NULL COMMENT '设备类别',
  `program` varchar(45) CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci NULL DEFAULT NULL COMMENT '程序号',
  `create_id` int(0) NOT NULL,
  `create_time` datetime(0) NULL DEFAULT NULL,
  `remark` varchar(200) CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci NULL DEFAULT NULL,
  `status` int(0) NULL DEFAULT NULL,
  `project_id` int(0) NULL DEFAULT NULL,
  `drawcode` varchar(45) CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci NULL DEFAULT NULL COMMENT '零件图纸号',
  `route_id` int(0) NOT NULL DEFAULT 0 COMMENT '工序Id',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8mb4 COLLATE = utf8mb4_0900_ai_ci COMMENT = '工艺清单表' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Table structure for siger_project_ims_test
-- ----------------------------
DROP TABLE IF EXISTS `siger_project_ims_test`;
CREATE TABLE `siger_project_ims_test`  (
  `id` int(0) NOT NULL AUTO_INCREMENT,
  `projectid` int(0) NULL DEFAULT NULL,
  `status` int(0) NULL DEFAULT NULL,
  `creator` int(0) NULL DEFAULT NULL,
  `editor` int(0) NULL DEFAULT NULL,
  `create_time` datetime(0) NULL DEFAULT NULL,
  `edit_time` timestamp(0) NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP(0),
  `tool_id` int(0) NULL DEFAULT NULL COMMENT '刀具号',
  `result` int(0) NULL DEFAULT 0 COMMENT '结果1合格2不合格',
  `machine_id` int(0) NULL DEFAULT 0 COMMENT '设备id',
  `location` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT '' COMMENT '刀位号',
  `order_number` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT '' COMMENT '检测单号',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8 COLLATE = utf8_general_ci ROW_FORMAT = Dynamic;

-- ----------------------------
-- Table structure for siger_project_ims_tool
-- ----------------------------
DROP TABLE IF EXISTS `siger_project_ims_tool`;
CREATE TABLE `siger_project_ims_tool`  (
  `id` int(0) NOT NULL AUTO_INCREMENT,
  `material_id` int(0) NOT NULL DEFAULT 0 COMMENT '物料id',
  `name` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT '',
  `category_id` int(0) NOT NULL COMMENT '类别id',
  `category_name` varchar(45) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL COMMENT '类别名',
  `number` varchar(45) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT '' COMMENT '编号',
  `part_no` varchar(45) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT '' COMMENT '料号',
  `image` varchar(500) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT '' COMMENT '2d图片地址',
  `video` varchar(500) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT '' COMMENT '3d文件地址',
  `project_id` int(0) NOT NULL,
  `status` int(0) NOT NULL,
  `tool_status` int(0) NOT NULL COMMENT '当前状态',
  `category` int(0) NOT NULL COMMENT '1.刀具 2.刀柄 3.附件',
  `create_time` datetime(0) NULL DEFAULT NULL ON UPDATE CURRENT_TIMESTAMP(0),
  `grind` int(0) NOT NULL DEFAULT 1 COMMENT '是否修磨 1是 2不是',
  `grind_times` int(0) NOT NULL DEFAULT 0 COMMENT '修磨次数',
  `grind_type` int(0) NOT NULL DEFAULT 0 COMMENT '修磨方式 1自主修磨 2外协修磨',
  `use_times` int(0) NOT NULL DEFAULT 0 COMMENT '使用次数',
  `image_name` varchar(200) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT '',
  `need_test` int(0) NULL DEFAULT 2 COMMENT '1需要测试2不需要测试',
  `need_detection` int(0) NULL DEFAULT 0 COMMENT '是否需要检测',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8 COLLATE = utf8_general_ci COMMENT = '刀具刀柄附件表' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Table structure for siger_project_ims_tool_choice
-- ----------------------------
DROP TABLE IF EXISTS `siger_project_ims_tool_choice`;
CREATE TABLE `siger_project_ims_tool_choice`  (
  `id` int(0) NOT NULL AUTO_INCREMENT,
  `workorder_id` int(0) NOT NULL DEFAULT 0 COMMENT '工单号id',
  `technology_id` int(0) NOT NULL DEFAULT 0 COMMENT '工艺单id',
  `cutter_number` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci NOT NULL DEFAULT '' COMMENT '刀位号',
  `project_id` int(0) NOT NULL,
  `status` int(0) NOT NULL DEFAULT 0 COMMENT '0: 未选择 1:已选择 2：已同步至wms',
  `creator` int(0) NOT NULL DEFAULT 0 COMMENT '创建人',
  `create_time` datetime(0) NOT NULL COMMENT '创建时间',
  `choice_status` int(0) NOT NULL DEFAULT 0 COMMENT '1： 未选择；1：已选择；2：已出库',
  `quantity` int(0) NOT NULL DEFAULT 0 COMMENT '数量',
  `part_no` varchar(45) CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci NOT NULL DEFAULT '' COMMENT '料号',
  `supplier_id` int(0) NOT NULL DEFAULT 0 COMMENT '供应商id',
  `material_id` int(0) NOT NULL DEFAULT 0,
  `remark` varchar(200) CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci NULL DEFAULT NULL COMMENT '备注',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8mb4 COLLATE = utf8mb4_0900_ai_ci COMMENT = '刀具选择表' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Table structure for siger_project_ims_tool_choice_summary
-- ----------------------------
DROP TABLE IF EXISTS `siger_project_ims_tool_choice_summary`;
CREATE TABLE `siger_project_ims_tool_choice_summary`  (
  `id` int(0) NOT NULL AUTO_INCREMENT,
  `technology_id` int(0) NOT NULL,
  `workorder_id` int(0) NOT NULL DEFAULT 0 COMMENT '工单号id',
  `cutter_number` varchar(45) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT '',
  `quantity` int(0) NOT NULL DEFAULT 0,
  `project_id` int(0) NOT NULL,
  `status` int(0) NOT NULL DEFAULT 0,
  `part_no` varchar(45) CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci NOT NULL DEFAULT '' COMMENT '料号',
  `supplier_id` int(0) NOT NULL DEFAULT 0 COMMENT '供应商id',
  `material_id` int(0) NOT NULL DEFAULT 0,
  `serial_no` varchar(100) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT '' COMMENT '入库序号',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8 COLLATE = utf8_general_ci ROW_FORMAT = Dynamic;

-- ----------------------------
-- Table structure for siger_project_ims_tool_config
-- ----------------------------
DROP TABLE IF EXISTS `siger_project_ims_tool_config`;
CREATE TABLE `siger_project_ims_tool_config`  (
  `id` int(0) NOT NULL AUTO_INCREMENT,
  `projectid` int(0) NULL DEFAULT NULL,
  `status` int(0) NULL DEFAULT NULL,
  `creator` int(0) NULL DEFAULT NULL,
  `editor` int(0) NULL DEFAULT NULL,
  `create_time` datetime(0) NULL DEFAULT NULL,
  `edit_time` timestamp(0) NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP(0),
  `code` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT '' COMMENT '刀具号',
  `tool_id` int(0) NULL DEFAULT 0 COMMENT '刀具id',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8 COLLATE = utf8_general_ci ROW_FORMAT = Dynamic;

-- ----------------------------
-- Table structure for siger_project_ims_tool_grind
-- ----------------------------
DROP TABLE IF EXISTS `siger_project_ims_tool_grind`;
CREATE TABLE `siger_project_ims_tool_grind`  (
  `id` int(0) NOT NULL AUTO_INCREMENT,
  `cutter_number` varchar(45) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT '' COMMENT '刀具号',
  `stock_number` varchar(45) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT '' COMMENT '刀具序号',
  `supplier_id` int(0) NOT NULL DEFAULT 0 COMMENT '供应商id',
  `part_no` varchar(45) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT '' COMMENT '料号',
  `material_id` int(0) NOT NULL DEFAULT 0 COMMENT '物料id',
  `remain_times` int(0) NOT NULL DEFAULT 0 COMMENT '剩余次数',
  `recycling_time` int(0) NOT NULL DEFAULT 0 COMMENT '回收时间',
  `grind_time` int(0) NOT NULL DEFAULT 0 COMMENT '修磨时间',
  `apply_time` int(0) NOT NULL DEFAULT 0 COMMENT '申请修磨时间',
  `project_id` int(0) NOT NULL DEFAULT 0,
  `status` int(0) NOT NULL DEFAULT 1 COMMENT '0无效1待修磨2修磨已申请3修磨完成',
  `source_type` int(0) NOT NULL DEFAULT 0 COMMENT '数据来源类型0其他 1无来源 2更换归还',
  `source_id` int(0) NOT NULL DEFAULT 0 COMMENT '数据来源id',
  `create_mid` int(0) NOT NULL DEFAULT 0,
  `create_time` int(0) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8 COLLATE = utf8_general_ci ROW_FORMAT = Dynamic;

-- ----------------------------
-- Table structure for siger_project_ims_tool_install
-- ----------------------------
DROP TABLE IF EXISTS `siger_project_ims_tool_install`;
CREATE TABLE `siger_project_ims_tool_install`  (
  `id` int(0) NOT NULL AUTO_INCREMENT,
  `package_id` int(0) NOT NULL DEFAULT 0 COMMENT '组装id',
  `tool_category` int(0) NOT NULL DEFAULT 1 COMMENT '刀具类型',
  `tool_code` varchar(100) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT '' COMMENT '刀具物料编号',
  `cutter_number` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT '' COMMENT '刀位号',
  `machine_code` varchar(50) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT '0' COMMENT '设备id',
  `project_id` int(0) NOT NULL DEFAULT 0 COMMENT '项目id',
  `status` int(0) NOT NULL DEFAULT 1 COMMENT '状态',
  `install_category` int(0) NOT NULL DEFAULT 1 COMMENT '安装类型 1：安装 2：卸载',
  `create_time` datetime(0) NULL DEFAULT NULL ON UPDATE CURRENT_TIMESTAMP(0),
  `install_userid` int(0) NULL DEFAULT 0,
  `uninstall_reason` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT '' COMMENT '卸载原因',
  `uninstall_time` datetime(0) NULL DEFAULT NULL ON UPDATE CURRENT_TIMESTAMP(0) COMMENT '卸载时间',
  `lastLife` varchar(11) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT '',
  `process_count` int(0) NULL DEFAULT 0 COMMENT '加工数量',
  `boom_code` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT '' COMMENT 'boom刀具编号',
  `install_code` varchar(100) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT '' COMMENT 'install_code',
  `material_id` int(0) NULL DEFAULT 0 COMMENT '物料id',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8 COLLATE = utf8_general_ci ROW_FORMAT = Dynamic;

-- ----------------------------
-- Table structure for siger_project_ims_tool_parameter
-- ----------------------------
DROP TABLE IF EXISTS `siger_project_ims_tool_parameter`;
CREATE TABLE `siger_project_ims_tool_parameter`  (
  `id` int(0) NOT NULL AUTO_INCREMENT,
  `tool_id` int(0) NOT NULL COMMENT '刀具id',
  `parameter_id` int(0) NOT NULL COMMENT '参数id',
  `parameter_value` varchar(45) CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci NOT NULL COMMENT '参数值',
  `project_id` int(0) NOT NULL,
  `status` int(0) NOT NULL,
  PRIMARY KEY (`id`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8mb4 COLLATE = utf8mb4_0900_ai_ci COMMENT = '刀具刀柄附件参数表' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Table structure for siger_project_ims_tool_replace_return
-- ----------------------------
DROP TABLE IF EXISTS `siger_project_ims_tool_replace_return`;
CREATE TABLE `siger_project_ims_tool_replace_return`  (
  `id` int(0) NOT NULL AUTO_INCREMENT,
  `workorder_id` int(0) NOT NULL DEFAULT 0 COMMENT '工单id',
  `workorder_code` varchar(45) CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci NOT NULL COMMENT '工单号',
  `material_id` int(0) NOT NULL DEFAULT 0 COMMENT '物料id',
  `part_no` varchar(45) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT '' COMMENT '料号',
  `quantity` int(0) NOT NULL DEFAULT 0 COMMENT '数量',
  `operate_mid` int(0) NOT NULL DEFAULT 0 COMMENT '操作人id',
  `operate_time` int(0) NOT NULL DEFAULT 0 COMMENT '操作时间',
  `operate_type` int(0) NOT NULL DEFAULT 0 COMMENT '操作方式 1更换 2归还',
  `supplier_id` int(0) NOT NULL DEFAULT 0 COMMENT '供应商id',
  `stock_number` varchar(45) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT '' COMMENT '刀具序号',
  `project_id` int(0) NOT NULL DEFAULT 0,
  `status` int(0) NOT NULL DEFAULT 1,
  `storage_id` int(0) NOT NULL DEFAULT 0 COMMENT '储位id',
  `create_mid` int(0) NOT NULL DEFAULT 0,
  `create_time` int(0) NOT NULL DEFAULT 0,
  `install_code` varchar(100) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT '' COMMENT 'install_code',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8 COLLATE = utf8_general_ci ROW_FORMAT = Dynamic;

-- ----------------------------
-- Table structure for siger_project_ims_tool_scrap
-- ----------------------------
DROP TABLE IF EXISTS `siger_project_ims_tool_scrap`;
CREATE TABLE `siger_project_ims_tool_scrap`  (
  `id` int(0) NOT NULL AUTO_INCREMENT,
  `material_id` int(0) NOT NULL DEFAULT 0 COMMENT '物料id',
  `part_no` varchar(45) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT '' COMMENT '料号',
  `cutter_number` varchar(45) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT '' COMMENT '刀具号',
  `review_mid` int(0) NOT NULL DEFAULT 0 COMMENT '审核人',
  `review_time` int(0) NOT NULL DEFAULT 0 COMMENT '审核时间',
  `review_remark` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT '' COMMENT '审核备注',
  `reason` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT '' COMMENT '报废原因',
  `create_time` int(0) NOT NULL DEFAULT 0 COMMENT '创建时间',
  `project_id` int(0) NOT NULL DEFAULT 0,
  `status` int(0) NOT NULL DEFAULT 1 COMMENT '0无效1待修磨2修磨已申请3修磨完成',
  `stock_number` varchar(45) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT '' COMMENT '刀具序号',
  `supplier_id` int(0) NOT NULL DEFAULT 0 COMMENT '供应商id',
  `source_type` int(0) NOT NULL DEFAULT 0 COMMENT '数据来源类型0其他 1无来源 2更换归还',
  `source_id` int(0) NOT NULL DEFAULT 0 COMMENT '数据来源id',
  `create_mid` int(0) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8 COLLATE = utf8_general_ci ROW_FORMAT = Dynamic;

-- ----------------------------
-- Table structure for siger_project_ims_use_record
-- ----------------------------
DROP TABLE IF EXISTS `siger_project_ims_use_record`;
CREATE TABLE `siger_project_ims_use_record`  (
  `id` int(0) NOT NULL AUTO_INCREMENT,
  `storage_id` int(0) NOT NULL DEFAULT 0 COMMENT '柜子id',
  `machine_id` int(0) NOT NULL DEFAULT 0 COMMENT '设备id',
  `cutter_number` varchar(10) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT '' COMMENT '刀位号',
  `project_id` int(0) NULL DEFAULT NULL,
  `status` int(0) NULL DEFAULT NULL,
  `count` int(0) NOT NULL DEFAULT 0 COMMENT '数量',
  `create_time` datetime(0) NULL DEFAULT NULL ON UPDATE CURRENT_TIMESTAMP(0),
  `use_userid` int(0) NULL DEFAULT NULL,
  `type` int(0) NULL DEFAULT 1 COMMENT '1: 领用 2：归还',
  `residual_life` int(0) NOT NULL DEFAULT 0 COMMENT '剩余寿命',
  `recycle_id` varchar(45) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT '' COMMENT '回收id',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8 COLLATE = utf8_general_ci ROW_FORMAT = Dynamic;

-- ----------------------------
-- Table structure for siger_project_ims_workorder
-- ----------------------------
DROP TABLE IF EXISTS `siger_project_ims_workorder`;
CREATE TABLE `siger_project_ims_workorder`  (
  `id` int(0) NOT NULL AUTO_INCREMENT,
  `workorder_code` varchar(45) CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci NOT NULL COMMENT '工单号',
  `technology_id` int(0) NOT NULL COMMENT '工艺单Id',
  `count` int(0) NULL DEFAULT NULL,
  `need_time` datetime(0) NULL DEFAULT NULL COMMENT '需求日期',
  `operator_id` int(0) NOT NULL COMMENT '处理人',
  `order_status` int(0) NOT NULL COMMENT '工单状态 0:未处理 1：备刀中 2：备刀完成',
  `project_id` int(0) NOT NULL,
  `status` int(0) NOT NULL,
  `create_time` datetime(0) NOT NULL COMMENT '创建时间',
  `tool_code` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci NULL DEFAULT '' COMMENT '刀具号',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8mb4 COLLATE = utf8mb4_0900_ai_ci COMMENT = '工单表' ROW_FORMAT = Dynamic;

SET FOREIGN_KEY_CHECKS = 1;
