﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Threading.Tasks;
using Siger.Middlelayer.Common;
using Siger.Middlelayer.Common.Helpers;
using Siger.Middlelayer.Redis.RedisEntities;
using Siger.Middlelayer.Redis.Repositories;
using Siger.Middlelayer.Share.Models;

namespace Siger.Middlelayer.Dapper.Utilities.Machine
{
    public class MachineManager
    {
        public static MachineRunningState GetMachineRunningStatesResult(int companyId, int projectId, IList<MachineData> machines)
        {
            machines = machines.GroupBy(t => t.machine_id).Select(t => t.FirstOrDefault()).ToList();
            var machineIds = machines.Select(m => m.machine_id).ToList();            
            var result = new MachineRunningState
            {
                ret = 1,
                projectid = projectId,
                companyid = companyId,
                ids = machineIds,
                startTime = DateTime.Now.ToString(ParameterConstant.DateFromZero),
                endTime = DateTime.Now.ToString(ParameterConstant.DateToEnd),
                iszy = "dev",
                machines = machineIds
            };

            var repository = new CNCEquipmentStateRepository(companyId, projectId, false);
            foreach (var machine in machines)
            {
                var machineState = repository.GetCNCEquipmentState(machine.machine_id);
                if (machineState != null)
                {
                    result.last_data.ret = 1;
                    var machineReturn = Mapper<CNCEquipmentState, MachineState>.Map(machineState);
                    machineReturn.Staus = machineState.Status;
                    machineReturn.machineTitle = machine.lastSectionTitle;
                    machineReturn.title = machine.lastSecondSectionTitle;
                    if (DateTime.Now.Subtract(DateTime.Parse(machineState.LastUpdateTime)).TotalMinutes > CommonConst.MachineShutDownThreshold)
                    {
                        machineReturn.Staus = 0; //关机
                        machineReturn.FeedRatio = 0;
                        machineReturn.FeedSpeed = 0;
                        machineReturn.SpindleSpeed1 = 0;
                        machineReturn.SpindleRatio = 0;
                        machineReturn.PN = "";
                        machineReturn.SPN = "";
                    }
                    if (machine.machine_id == 2002 && machineReturn.Staus == 0)
                    { 
                    }
                    result.last_data.data.Add(machineReturn);
                }
                else
                {
                    var machineReturn = new MachineState
                    {
                        MachineId = machine.machine_id,
                        machineTitle = machine.lastSectionTitle,
                        title = machine.lastSecondSectionTitle
                    };
                    if (machine.machine_id == 2002 && machineReturn.Staus == 0)
                    {
                    }
                    result.last_data.data.Add(machineReturn);
                }
                result.data.Add(machine.machine_id, new DataInfo
                {
                    companyid = companyId.ToString(),
                    machineid = machine.machine_id.ToString(),
                    machinecode = machine.machine_code,
                    machinename = machine.machine_name,
                    op = machine.lastSectionTitle,
                    pop = machine.lastSecondSectionTitle,
                    projectid = projectId.ToString(),
                    username = "NA"
                });
            }
            repository.Dispose();

            return result;
        }

        public static async Task<MachineRunningState> GetMachineRunningStatesResultAsync(int companyId, int projectId,
            IList<MachineData> machines)
        {
            return await Task.Run(() => GetMachineRunningStatesResult(companyId, projectId, machines));
        }
    }
}
