﻿using Newtonsoft.Json;
using System;
using System.Collections.Generic;
using Siger.Middlelayer.Redis.Model;

namespace Siger.Middlelayer.Redis.Repositories
{
    public class AlarmConditionRepository : RedisRepositoryBase
    {
        private readonly bool _dispose;
        public AlarmConditionRepository(int companyId, int projectId, bool dispose = true) : base(companyId, projectId)
        {
            _dispose = dispose;
        }

        public void Dispose()
        {
            Client?.Dispose();
        }
        public void Add(int cutterlocationid, IList<RedisToolAlertConditionModel> record)
        {
            if (record == null)
                return;
            if (record.Count == 0)
                return;
            try
            {
                Client.HSet(HashAlarmCondition, cutterlocationid.ToString(), JsonConvert.SerializeObject(record));
            }
            catch
            {
                throw;
            }
            finally
            {
                if (_dispose)
                {
                    Dispose();
                }
            }
        }

        public void Update(int cutterlocationid, IList<RedisToolAlertConditionModel> record)
        {
            try
            {
                if (!string.IsNullOrEmpty(Client.HGet(HashAlarmCondition, cutterlocationid.ToString())))
                {
                    Add(cutterlocationid, record);
                }
            }
            catch
            {
                throw;
            }
            finally
            {
                Client?.Dispose();
            }
        }

        public void DeleteChangeToolsRecord(int cutterlocationid)
        {
            try
            {
                Client.HDel(HashAlarmCondition, cutterlocationid.ToString());
            }
            catch
            {
                throw;
            }
            finally
            {
                Client?.Dispose();
            }
        }
    }
}
