﻿using Siger.Middlelayer.Common;
using Siger.Middlelayer.Common.Helpers;
using Siger.Middlelayer.Redis.RedisEntities;
using System;
using System.Collections.Generic;

namespace Siger.Middlelayer.Redis.Repositories
{
    public class ApiCountRepository : RedisRepositoryBase
    {
        private readonly bool _dispose;
        public ApiCountRepository(int companyId, int projectId, bool dispose = true) : base(companyId, projectId)
        {
            _dispose = dispose;
        }

        /// <summary>
        /// 返回所有的调用记录
        /// </summary>
        /// <returns></returns>
        public List<ApiSuccessEntity> GetSuccessEntities()
        {
            try
            {
                var entities = new List<ApiSuccessEntity>();
                var hiss = Client.HGetAll<string>(ApiSuccessHash);
                foreach (var his in hiss)
                {
                    var value = JsonHelper.DeserializerJsonResult<ApiSuccessEntity>(his.Value);
                    if (value != null)
                    {
                        entities.Add(value);
                    }
                }
                return entities;
            }
            finally
            {
                if (_dispose)
                {
                    Dispose();
                }
            }
        }

        /// <summary>
        /// 设置接口访问次数
        /// </summary>
        /// <returns></returns>
        public void SetApiCount(string url)
        {
            try
            {
                var his = Client.HGet(ApiSuccessHash, url);
                if (string.IsNullOrWhiteSpace(his))
                {
                    var entity = new ApiSuccessEntity
                    {
                        count = 1,
                        lastupdatetime = DateTime.Now.ToString(ParameterConstant.DateTimeFormat),
                        url = url
                    };
                    Client.HSet(ApiSuccessHash, url, JsonHelper.SerializerToJsonString(entity));
                }
                else
                {
                    var entity = JsonHelper.DeserializerJsonResult<ApiSuccessEntity>(his);
                    if (entity != null)
                    {
                        entity.count += 1;
                        entity.lastupdatetime = DateTime.Now.ToString(ParameterConstant.DateTimeFormat);
                        entity.url = url;
                        Client.HSet(ApiSuccessHash, url, JsonHelper.SerializerToJsonString(entity));
                    }
                }
            }
            catch(Exception ex)
            {
                Siger.Middlelayer.Common.Log.Logger.WriteLineError(ex.Message);
            }
            finally
            {
                if (_dispose)
                {
                    Dispose();
                }
            }
        }

        /// <summary>
        /// 设置接口访问次数
        /// </summary>
        /// <returns></returns>
        public void AddFiledApi(string url, string msg, string error, int userid, string parameter)
        {
            try
            {
                var entity = new ApiFailedEntity
                {
                    userid = userid,
                    msg = msg,
                    error = error,
                    parameter = parameter,
                    time = DateTime.Now.ToString(ParameterConstant.DateTimeFormat),
                    url = url
                };
                Client.HSet(ApiFailedHash, DateTime.Now.ToString(ParameterConstant.DateTimeMilliSecondFormat), JsonHelper.SerializerToJsonString(entity));
            }
            finally
            {
                if (_dispose)
                {
                    Dispose();
                }
            }
        }

        /// <summary>
        /// 返回所有的失败调用记录
        /// </summary>
        /// <returns></returns>
        public List<ApiFailedEntity> GetFailedEntities()
        {
            try
            {
                var entities = new List<ApiFailedEntity>();
                var hiss = Client.HGetAll<string>(ApiFailedHash);
                foreach (var his in hiss)
                {
                    entities.Add(JsonHelper.DeserializerJsonResult<ApiFailedEntity>(his.Value));
                }
                return entities;
            }
            finally
            {
                if (_dispose)
                {
                    Dispose();
                }
            }
        }

        public void Dispose()
        {
            Client?.Dispose();
        }
    }
}
