﻿using System;
using System.Collections.Generic;
using System.Text;
using Siger.Middlelayer.Common;
using Siger.Middlelayer.Common.Helpers;
using Siger.Middlelayer.Redis.Model;
using Siger.Middlelayer.Redis.RedisEntities;

namespace Siger.Middlelayer.Redis.Repositories
{
    public class CncParameterExceptionConfigRepository: RedisRepositoryBase
    {
        public CncParameterExceptionConfigRepository(int companyId, int projectId) : base(companyId, projectId)
        {
        }

        /// <summary>
        /// 设置参数异常报警阈值
        /// </summary>
        /// <returns></returns>
        public void SetParameterExceptionConfig(RedisMachineParamAlarmModellarm alarm)
        {
            try
            {
                var configs = new List<ParameterException>
                {
                    new ParameterException
                    {
                        Type = (int) ParameterType.AxisSpeed,
                        DownLimit = alarm.axis_speed_low,
                        UpLimit = alarm.axis_speed_top
                    },
                    new ParameterException
                    {
                        Type = (int) ParameterType.AxisRate,
                        DownLimit = alarm.axis_rate_low,
                        UpLimit = alarm.axis_rate_top
                    },
                    new ParameterException
                    {
                        Type = (int) ParameterType.FeedRate,
                        DownLimit = alarm.feed_rate_low,
                        UpLimit = alarm.feed_rate_top
                    }
                };

                var config = JsonHelper.SerializerToJsonString(configs);

                Client.HSet(HashParameterExceptionConfigName, alarm.machine_id.ToString(), config);
            }
            catch
            {
                throw;
            }
            finally
            {
                Client?.Dispose();
            }
        }

        public void DeleteParameterExceptionConfig(int machineId)
        {
            try
            {
                Client.HDel(HashParameterExceptionConfigName, machineId.ToString());
            }
            catch
            {
                throw;
            }
            finally
            {
                Client?.Dispose();
            }
        }
    }
}
