﻿using System;
using System.Collections.Generic;
using System.Text;
using Siger.Middlelayer.Common.Helpers;
using Siger.Middlelayer.Redis.RedisEntities;
namespace Siger.Middlelayer.Redis.Repositories
{
    public class KMtrendTransferRepository: RedisRepositoryBase
    {
        public KMtrendTransferRepository(int companyId, int projectId) : base(companyId, projectId)
        {
        }
        /// <summary>
        /// 获取趋势线 数据分析
        /// </summary>
        /// <param name="filed"></param>
        public KMTrendTransfer GetKMtransferData(string filed)
        {
            try
            {
                var data = Client.HGet(HashTrendTransfer, filed);
                if (!string.IsNullOrEmpty(data))
                {
                   return JsonHelper.DeserializerJsonResult<KMTrendTransfer>(data);
                }
                return null;
            }
            catch (Exception e)
            {
                throw e;
            }
            finally
            {
                Client?.Dispose();
            }

        }

        /// <summary>
        /// 加工次数与负载图
        /// </summary>
        /// <param name="key"></param>
        /// <returns></returns>
        public KMTrendTransferEntity GetKmTrendTransferEntity(string key)
        {
            try
            {
                var data = Client.HGet(HashTrendTransfer, key);
                if (!string.IsNullOrEmpty(data))
                {
                    return JsonHelper.DeserializerJsonResult<KMTrendTransferEntity>(data);
                }
                return null;
            }
            catch (Exception e)
            {
                throw e;
            }
            finally
            {
                Client?.Dispose();
            }
        }
    }
}
