﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using Siger.Middlelayer.Common.Helpers;
using Newtonsoft.Json;

namespace Siger.Middlelayer.Redis.Repositories
{
    public class QMSParameterRuleKValueConfigRepository : RedisRepositoryBase
    {
        private readonly bool _dispose;
        public QMSParameterRuleKValueConfigRepository(int companyId, int projectId, bool dispose = true) : base(companyId, projectId)
        {
            _dispose = dispose;
        }

        public void SaveRuleKValue(List<int> k_value, List<int> rule)
        {
            try
            {
                var dic = new Dictionary<string, int>();
                if (k_value.Any())
                {
                    for(var i = 0; i < k_value.Count; i++)
                    {
                        dic.Add((i + 1).ToString(), k_value[i]);
                    }
                }
                Client.HSet(QMSParameterRuleKValueConfig, "kValue", JsonConvert.SerializeObject(dic));
                Client.HSet(QMSParameterRuleKValueConfig, "rule", JsonConvert.SerializeObject(rule));
            }
            catch
            {
                throw;
            }
            finally
            {
                if (_dispose)
                {
                    Dispose();
                }
            }
        }

        public void Dispose()
        {
            Client?.Dispose();
        }
    }
}
