﻿using System;

namespace Siger.Middlelayer.License.ViewModels
{
    public abstract class BaseViewModel: NotificationObject,IDisposable
    {
        private string _description;
        private bool _isVisible = true;
        private bool _isEnable = true;

        /// <summary>
        /// Description, display on UI
        /// </summary>
        public string Description
        {
            get { return _description; }
            set
            {
                if (_description != value)
                {
                    _description = value;
                    OnPropertyChanged(() => Description);
                }
            }
        }

        /// <summary>
        /// A Flag indicates this UI is visible
        /// </summary>
        public bool IsVisible
        {
            get { return _isVisible; }
            set
            {
                if (_isVisible != value)
                {
                    _isVisible = value;
                    OnIsVisible();
                    OnPropertyChanged(() => IsVisible);
                }
            }
        }

        /// <summary>
        /// A Flag indicates this UI is enabled
        /// </summary>
        public bool IsEnabled
        {
            get { return _isEnable; }
            set
            {
                if (_isEnable != value)
                {
                    _isEnable = value;
                    OnIsEnabledChanged();
                    OnPropertyChanged(() => IsEnabled);
                }
            }
        }

        protected virtual void OnIsEnabledChanged()
        {
            //TODO On IsEnabled changed, child class can override implement it
        }

        protected virtual void OnIsVisible()
        {
            //child class can override implement it
        }

        public virtual void Dispose()
        {
            //Dispose view model resources, child class can override implement it
        }
    }
}
