﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Threading.Tasks;

namespace Siger.ApiNingxiaShared.Response
{
    public class ResponseGetToolInstallData
    {
        /// <summary>
        /// 设备id
        /// </summary>
        public int machine_id { get; set; }
        /// <summary>
        /// 刀位号
        /// </summary>
        public string tool_location { get; set; }
        /// <summary>
        /// 装刀时间
        /// </summary>
        public string loadtime { get; set; }
        /// <summary>
        /// 道具编号
        /// </summary>
        public string tool_number { get; set; }
        /// <summary>
        /// 刀具名称
        /// </summary>
        public string tool_name { get; set; }
        /// <summary>
        /// 装刀人
        /// </summary>
        public string load_user { get; set; }
        /// <summary>
        /// 刀具寿命
        /// </summary>
        public string tool_life { get; set; } = string.Empty;
        /// <summary>
        /// 刀具类型
        /// </summary>
        public string tool_type { get; set; }
    }

    public class ResponseGetToolStockData
    {
        /// <summary>
        /// 刀具编号
        /// </summary>
        public string tool_number { get; set; }
        /// <summary>
        /// 刀具名称
        /// </summary>
        public string tool_name { get; set; }
        /// <summary>
        /// 库存数量
        /// </summary>
        public int warehouse_qty { get; set; }
        /// <summary>
        /// 最小库存
        /// </summary>
        public int warehouse_min { get; set; }
        /// <summary>
        /// 刀具领用量
        /// </summary>
        public int tool_cost { get; set; } = 0;
        /// <summary>
        /// 刀具类型
        /// </summary>
        public string tool_type { get; set; }

    }
}
