﻿using System;
using System.Collections.Generic;
using System.Globalization;
using System.Linq;
using Microsoft.AspNetCore.Mvc;
using Newtonsoft.Json;
using Siger.ApiChangLing.Result;
using Siger.Middlelayer.CncRepository.Repositories.Interface;
using Siger.Middlelayer.CncRepository.Request;
using Siger.Middlelayer.CncRepository.Response;
using Siger.Middlelayer.Common;
using Siger.Middlelayer.Common.Configuration;
using Siger.Middlelayer.Common.Extensions;
using Siger.Middlelayer.Common.Helpers;
using Siger.Middlelayer.Common.ModuleEnum;
using Siger.Middlelayer.Repository.Repositories.Interface;
using Siger.Middlelayer.Repository.Response;
using Siger.Middlelayer.Share.Models;
using Siger.Middlelayer.Share.Utilities;
using Siger.Middlelayer.TpmRepository.Entities;
using Siger.Middlelayer.TpmRepository.Repositories.Interface;
using Siger.ApiCommon.Filters;
using Siger.Middlelayer.WmsRepository.Repositories.Interface;
using Siger.Middlelayer.WmsRepository.Request;

namespace Siger.ApiChangLing.Controllers
{
    [NoTokenValidateFilter]
    public class SynInformationController : BaseController
    {
        private readonly ISparepartRepository _sparepartRepository;
        private readonly ISparepartTypeRepository _sparepartTypeRepository;
        private readonly Isiger_wms_stockRepository _stockRepository;

        public SynInformationController(ISparepartRepository sparepartRepository, ISparepartTypeRepository sparepartTypeRepository,Isiger_wms_stockRepository stockRepository)
        {
            _sparepartRepository = sparepartRepository;
            _sparepartTypeRepository = sparepartTypeRepository;
            _stockRepository = stockRepository;
        }
        /// <summary>
        /// 备件数据接口
        /// </summary>
        /// <param name="request"></param>
        /// <returns></returns>
        [HttpPost]
        public IActionResult SyncSpareparts([FromBody] List<RequestSparepart> request)
        {
            if (request == null || !request.Any())
            {
                throw new BadRequestException(CommonEnum.Fail);
            }
            var list = new List<siger_project_sparepart>();
            foreach (var data in request)
            {
                var typeid = _sparepartTypeRepository.Get(f => f.projectid == ProjectId && f.status != 0 && f.title == data.sparepart_type)?.id ?? 0;
                var model = new siger_project_sparepart
                {
                    code = data.sparepart_code,
                    title = data.sparepart_name,
                    typeid = typeid,
                    brand = data.brand,
                    price = data.price.ToDouble(),
                    sku = data.storage_qty.ToInt(),
                    warehouse = data.storage_location,
                    projectid = ProjectId,
                    create_ip = string.Empty,
                    description = string.Empty,
                    image = string.Empty,
                    material = string.Empty,
                    order_time = UnixTimeHelper.GetNow(),
                    param = string.Empty,
                    remark = string.Empty,
                    sku_report_mid = string.Empty,
                    time = UnixTimeHelper.GetNow(),
                    supplier = string.Empty,
                    unit = string.Empty,
                };
                list.Add(model);
            }
            if (_sparepartRepository.InsertList(list))
            {
                return new ObjectResult(CommonEnum.Succefull);
            }
            throw new BadRequestException(CommonEnum.Fail);

        }
        /// <summary>
        /// 刀具采购入库
        /// </summary>
        /// <param name="request"></param>
        /// <returns></returns>
        [HttpPost]
        public IActionResult SyncTools([FromBody] RequestPurchaseTools request)
        {
            if (_stockRepository.SyncToolData(request, ProjectId))
            {
                return new ObjectResult(CommonEnum.Succefull);
            }
            throw new BadRequestException(CommonEnum.Fail);
        }
    }
}