﻿using Microsoft.AspNetCore;
using Microsoft.AspNetCore.Hosting;
using Microsoft.Extensions.Configuration;
using Microsoft.Extensions.Hosting;

namespace Siger.ApiChangLing
{
    public class Program
    {
        public static void Main(string[] args)
        {
            CreateHostBuilder(args).Build().Run();
        }

        public static IHostBuilder CreateHostBuilder(string[] args) =>
                   Host.CreateDefaultBuilder(args).ConfigureAppConfiguration(builder =>
                   {
                       builder.AddJsonFile("appsettings.json", optional: true);
                   })
              .ConfigureWebHostDefaults(webBuilder =>
              {
                  webBuilder.UseUrls(args.Length > 1 ? $"http://*:{args[1]}" : "http://*:8012");
                  webBuilder.UseStartup<Startup>();
              });
    }
}
