﻿using System;
using System.Collections.Generic;
using System.Linq.Expressions;
using Microsoft.AspNetCore.Mvc;
using Siger.ApiCommon.Result;
using Siger.Middlelayer.AccRepository.Entities;
using Siger.Middlelayer.AccRepository.Repositories.Interface;
using Siger.Middlelayer.AccRepository.Response;
using Siger.Middlelayer.AccRepository.Request;
using Siger.Middlelayer.Common;
using Siger.Middlelayer.Common.Extensions;
using Siger.Middlelayer.Repository.Repositories.Interface;
using Siger.Middlelayer.Repository;
using Siger.Middlelayer.Repository.Extensions;
using System.Linq;
using Siger.Middlelayer.Repository.Entities;

namespace Siger.ApiACC.Controllers
{
    public class PrintSettingController :BaseController
    {
        private readonly IUnitOfWork _unitOfWork;
        private readonly ISigerPrinterSetting _printerSetting;
        private readonly ISigerProjectLevelSectionRepository _sigerProjectLevelSection;

        public PrintSettingController(IUnitOfWork unitOfWork, ISigerPrinterSetting printerSetting,
            ISigerProjectLevelSectionRepository sigerProjectLevelSection)
        {
            _unitOfWork = unitOfWork;
            _printerSetting = printerSetting;
            _sigerProjectLevelSection = sigerProjectLevelSection;
        }

        [HttpGet]
        public IActionResult Getlist(int station, int page = 1, int pagesize = 10)
        {
            var levelstation = _sigerProjectLevelSection.GetLevelSectionIds(station, ProjectId).ToList();
            var data = _printerSetting.GetPagedList(levelstation, ProjectId, page, pagesize);
            var response = new List<ResponsePrinterSetting>();

            foreach (var item in data.Data)
            {
                var result = _sigerProjectLevelSection.GetParentLevelSections(item.station, ProjectId).OrderBy(o => o.id).ToList();
                response.Add(new ResponsePrinterSetting
                {
                    id = item.id,
                    printtype = item.printtype,
                    station = item.station,
                    station_value =  result.Select(p=>p.title).ToList(),
                    port = item.port,
                    uid = item.uid,
                    uid_value = item.uid_value,
                    printername = item.printername,
                    transdatetime = item.transdatetime,
                    parentids= result.Select(p=>p.id).ToList()
                });
            }

            return new PagedObjectResult(response, data.Total,page,pagesize);
        }

        [HttpPost]
        public IActionResult Add([FromBody] RequestPrinterSetting printerSetting)
        {
            var check = _printerSetting.Get(t => t.station == printerSetting.Station && t.status == (int)RowState.Valid && t.projectId == ProjectId);
            if (check != null)
            {
                throw new BadRequestException(RequestEnum.PrinterSettingDataRepeat);
            }

            if(_sigerProjectLevelSection.IsExist(f=>f.parentid == printerSetting.Station) )
            {
                throw new BadRequestException(RequestEnum.LineError);
            }

            _printerSetting.Insert(new SigerTrPrinterSetting
            {
                projectId = ProjectId,
                station = printerSetting.Station,
                printername = printerSetting.PrinterName,
                printtype = printerSetting.PrintType,
                port = printerSetting.Port,
                uid = UserId.ToString(),
                transdatetime = DateTime.Now
            });
            if (_unitOfWork.Commit() > 0)
                return new ObjectResult(CommonEnum.Succefull);
            throw new BadRequestException(CommonEnum.Fail);
        }

        [HttpPost]
        public IActionResult Modify([FromBody] RequestModifyPrinterSetting setting)
        {
            var NewObj = _printerSetting.Get(setting.Id);
            if (NewObj == null)
                throw new BadRequestException(CommonEnum.RecordNotFound);

            var check = _printerSetting.Get(t => t.line == setting.Line && t.station == setting.Station
                && t.status == (int)RowState.Valid && t.projectId == ProjectId && t.id != NewObj.id);
            if (check != null)
            {
                throw new BadRequestException(RequestEnum.PrinterSettingDataRepeat);
            }

            NewObj.line = setting.Line;
            NewObj.station = setting.Station;
            NewObj.printername = setting.PrinterName;
            NewObj.printtype = setting.PrintType;
            NewObj.port = setting.Port;

            _printerSetting.Update(NewObj);
            if (_unitOfWork.Commit() > 0)
                return new ObjectResult(CommonEnum.Succefull);
            throw new BadRequestException(CommonEnum.Fail);
        }

        [HttpGet]
        public IActionResult Delete(string id)
        {
            foreach (var item in id.Split(','))
            {
                var NewObj = _printerSetting.Get(item.ToInt());
                if (NewObj == null)
                    throw new BadRequestException(CommonEnum.RecordNotFound);
                NewObj.status = (int)RowState.Invalid;
                _printerSetting.Update(NewObj);
            }

            if (_unitOfWork.Commit() > 0)
                return new ObjectResult(CommonEnum.Succefull);
            throw new BadRequestException(CommonEnum.Fail);
        }
    }
}
