﻿using Siger.Middlelayer.AccRepository;
using Siger.Middlelayer.AccRepository.Entities;
using Siger.Middlelayer.CncRepository;
using Siger.Middlelayer.Repository;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Threading.Tasks;
using static Siger.Middlelayer.Share.Enum.ModuleEnum.Automation;

namespace Siger.ApiACC.Tasks
{
    public class DBhelper : IDisposable
    {
       

        private readonly ApiCncDbContext CncDbContext;
        private readonly ApiAccDbContext AccDbContext;
        private readonly ApiConfigDbContext ConfigDbContext;

        public DBhelper()
        {
            CncDbContext = new ApiCncDbContext();
            AccDbContext = new ApiAccDbContext();
            ConfigDbContext = new ApiConfigDbContext();
        }


        internal bool CanTask(int projectId, int section)
        {
            var taskObj = AccDbContext.siger_automation_task_list.FirstOrDefault(f => f.projectId == projectId && f.status >= (int)TaskResultStatus.Cancel && f.status < (int)TaskResultStatus.Complated);

            if (taskObj == null)
                return true;
            else
                return false;

        }
        /// <summary>
        /// 获取未推送tasklist
        /// </summary>
        /// <param name="projectId"></param>
        /// <returns></returns>
        public IEnumerable<siger_automation_task_list> GetTaskList(int projectId)
        {
           var taskObjs = AccDbContext.siger_automation_task_list.Where(f => f.projectId == projectId && f.send==0 && f.status >= (int)TaskResultStatus.Cancel && f.status < (int)TaskResultStatus.Complated);

            return taskObjs;
        }
        public siger_automation_fixture_tools_monitor GetMonitor(int section)
        {
            return AccDbContext.siger_automation_fixture_tools_moniter.FirstOrDefault(f => f.section == section);
        }
        public bool UpdateTask(siger_automation_task_list taskNo)
        {
            AccDbContext.siger_automation_task_list.Update(taskNo);
            return AccDbContext.SaveChanges() > 0;
        }
        public void Dispose()
        {
            CncDbContext?.Dispose();
            AccDbContext?.Dispose();
            ConfigDbContext?.Dispose();
        }

    }
}
