﻿using System;
using System.Collections.Generic;
using Siger.ApiCommon.Result;
using Siger.Middlelayer.Share.Models;
using Siger.Middlelayer.Share.Models.Cnc;

namespace Siger.ApiCNC.Result
{
    public class MachineCanvasParetoInfoResult : OtherObjectResult
    {
        public string startTime { get; set; }

        public string endTime { get; set; }

        public double total_time_span { get; set; }

        public IList<Canvas> canvas { get; set; }

        public IList<Pareto> pareto { get; set; }

        public MachineCanvasParetoInfoResult()
        {
            canvas = new List<Canvas>();

            pareto = new List<Pareto>();
        }
    }

    public class MachineCanvasResult : OtherObjectResult
    {
        public string startTime { get; set; }

        public string endTime { get; set; }

        public double total_time_span { get; set; }

        public IList<Canvas> canvas { get; set; }

        public MachineCanvasResult()
        {
            canvas = new List<Canvas>();
        }
    }

    public class MachineYieldResult : OtherObjectResult
    {
        public int machineId { get; set; }

        public IList<ProgramYield> programNos { get; set; }

        public MachineYieldResult()
        {
            programNos = new List<ProgramYield>();
        }
    }
}

