﻿using System;
using System.Net;
using Microsoft.AspNetCore.Mvc;
using Microsoft.AspNetCore.Mvc.Filters;
using Microsoft.AspNetCore.Routing;
using Siger.ApiCommon.Exceptions;
using Siger.Middlelayer.Common;
using Siger.Middlelayer.Log;
namespace Siger.ApiCommon.Filters
{
    public class ApiExceptionFilter: IExceptionFilter
    {
        public void OnException(ExceptionContext context)
        {
            if (context.Exception is BadRequestException badRequestException)
            {
                context.HttpContext.Response.StatusCode = (int)HttpStatusCode.OK;
                context.Result = new ObjectResult(new ResultFilter.ResultObject(0, (int)Convert.ChangeType(badRequestException.ExceptionEnum, typeof(int)), badRequestException.Message));
            }
            else if (context.Exception is ServerException serverException)
            {
                context.HttpContext.Response.StatusCode = (int)HttpStatusCode.OK;
                context.Result = new ObjectResult(new ResultFilter.ClientObject(0, serverException.msg, serverException.Message));
            }
            else if (context.Exception is ClientException clientException)
            {
                context.HttpContext.Response.StatusCode = (int)HttpStatusCode.OK;
                context.Result = new ObjectResult(new ResultFilter.ClientDeviceObject(0, clientException.msg, ""));
            }
            else if(context.Exception is CommonException commonException)
            {
                context.HttpContext.Response.StatusCode = (int)HttpStatusCode.OK;
                context.Result = new ObjectResult(new ResultFilter.ResultObject(0, (int)CommonEnum.Fail, commonException.msg));
            }
            else
            {
                context.HttpContext.Response.StatusCode = (int)HttpStatusCode.InternalServerError;
                context.Result = new ObjectResult(new ResultFilter.ResultObject(0, (int)CommonEnum.SystemExcetion, context.Exception.Message));
                WriteLog(context.RouteData, context,
                    context.Exception.Message + context.Exception.StackTrace + context.Exception.InnerException);
            }
            context.ExceptionHandled = true;
        }

        private void WriteLog(RouteData routeData, ExceptionContext context, string msg)
        {
            var controllerName = routeData.Values["controller"];
            var actionName = routeData.Values["action"];
            var parameter = string.Empty;
            switch (context.HttpContext.Request.Method)
            {
                case "GET":
                    if (context.HttpContext.Request.QueryString.HasValue)
                    {
                        parameter = context.HttpContext.Request.QueryString.Value;
                    }
                    break;
                case "POST": //如果加上[FromBody]，则取不到body里的参数
                    break;
                default:
                    break;
            }
            
            var message = $"controller: {controllerName}, action: {actionName}, parameter: {parameter}, message: {msg}";
            Logger.WriteLineError(message);
        }
    }
}
