﻿using System.Collections.Generic;
using Microsoft.AspNetCore.Mvc;

namespace Siger.ApiCommon.Result
{
    public class AppPagedEntityResult<T> : ActionResult
    {
        public IEnumerable<T> data { get; set; }

        public int total { get; set; }

        public int page { get; set; }

        public int pagesize { get; set; }

        public AppPagedEntityResult(IEnumerable<T> value, int totalValue, int pageValue = 1, int pagesizeValue = 10)
        {
            data = value;
            total = totalValue;
            page = pageValue;
            pagesize = pagesizeValue;
        }
    }
}
