﻿using Microsoft.AspNetCore.Builder;
using Siger.Middlelayer.Common;
using Microsoft.Extensions.DependencyInjection;
using System.IO;
using Microsoft.OpenApi.Models;
using System.Linq;

namespace Siger.ApiCommon.Utilities
{
    public static class Swagger
    {
        public static void AddSwagger(IServiceCollection services, Module module)
        {
            string strLable = string.Empty;
            string strRepository = string.Empty;
            switch (module)
            {
                case Module.Acc:
                    strLable = "Siger.ApiACC.xml";
                    strRepository = "Siger.Middlelayer.AccRepository.xml";
                    break;
                case Module.Cnc:
                    strLable = "Siger.ApiCNC.xml";
                    strRepository = "Siger.Middlelayer.CncRepository.xml";
                    break;
                case Module.Config:
                    strLable = "Siger.ApiConfig.xml";
                    strRepository = "Siger.Middlelayer.Repository.xml";
                    break;
                case Module.Dnc:
                    strLable = "Siger.ApiDNC.xml";
                    strRepository = "Siger.Middlelayer.DncRepository.xml";
                    break;
                case Module.Tools:
                    strLable = "Siger.ApiTools.xml"; 
                    break;
                case Module.Tpm:
                    strLable = "Siger.ApiTpm.xml";
                    strRepository = "Siger.Middlelayer.TpmRepository.xml";
                    break;
                case Module.Wms:
                    strLable = "Siger.ApiWMS.xml";
                    strRepository = "Siger.Middlelayer.WmsRepository.xml";
                    break;
                case Module.Tlm:
                    strLable = "Siger.ApiTLM.xml";
                    strRepository = "Siger.Middlelayer.TlmRepository.xml";
                    break;
                case Module.Qms:
                    strLable = "Siger.ApiQMS.xml";
                    strRepository = "Siger.Middlelayer.QmsRepository.xml";
                    break;
                case Module.Esop:
                    strLable = "Siger.ApiEsop.xml";
                    strRepository = "Siger.Middlelayer.EsopRepository.xml";
                    break;
                case Module.Dashboard:
                    strLable = "Siger.ApiDashboard.xml";
                    strRepository = "Siger.Middlelayer.DashboardRepository.xml";
                    break;
                case Module.ChangLing:
                    strLable = "Siger.ApiChangLing.xml";
                    break;
                case Module.Fjw:
                    strLable = "Siger.ApiFjw.xml";
                    break;
                case Module.Kpi:
                    strLable = "Siger.ApiKPI.xml"; 
                    strRepository = "Siger.Middlelayer.KpiRepository.xml";
                    break;
                case Module.NingxiaShared:
                    strLable = "Siger.ApiNingxiaShared.xml";
                    //strRepository = "Siger.Middlelayer.TlmRepository.xml";
                    break;
                case Module.IMS:
                    strLable = "Siger.ApiIMS.xml";
                    //strRepository = "Siger.Middlelayer.TlmRepository.xml";
                    break;
                default:
                    strLable = "Not Config";
                    break;
            }
            services.AddSwaggerGen(c =>
            {
                c.SwaggerDoc(module.ToString().ToLower(), new OpenApiInfo
                {
                    Version = "v1",
                    Title = "API Doc",
                    Description = "Restful API Document",
                    TermsOfService = null,
                    Contact = new OpenApiContact
                    {
                        Name = "SigerData",
                        Url = null,
                        Email = ""
                    }
                });
                c.ResolveConflictingActions(apiDescriptions => apiDescriptions.First());

                var basePath = Path.GetDirectoryName(typeof(Program).Assembly.Location);
                var xmlPath = Path.Combine(basePath, strLable);
                c.IncludeXmlComments(xmlPath);
                if (!string.IsNullOrEmpty(strRepository))
                {
                    var repositoryPath = Path.Combine(basePath, strRepository);
                    c.IncludeXmlComments(repositoryPath);
                }
            });
        }
        public static IApplicationBuilder RegisterSwagger(this IApplicationBuilder app, Module module)
        {
            string strLable = string.Empty;
            switch (module)
            {
                case Module.Acc:
                    strLable = "Siger ACC"; 
                    break;
                case Module.Cnc:
                    strLable = "Siger CNC";
                    break;
                case Module.Config:
                    strLable = "Siger Config";
                    break;
                case Module.Dnc:
                    strLable = "Siger DNC";
                    break;
                case Module.Tools:
                    strLable = "Siger Tools";
                    break;
                case Module.Tpm:
                    strLable = "Siger Tpm";
                    break;
                case Module.Tlm:
                    strLable = "Siger Tlm";
                    break;
                case Module.Esop:
                    strLable = "Siger Esop";
                    break;
                case Module.Qms:
                    strLable = "Siger QMS";
                    break;
                case Module.Dashboard:
                    strLable = "Siger Dashboard";
                    break;
                case Module.ChangLing:
                    strLable = "Siger ChangLing";
                    break;
                case Module.Fjw:
                    strLable = "Siger Fjw";
                    break;
                case Module.NingxiaShared:
                    strLable = "Siger NingxiaShared";
                    break;
                default:
                    strLable = "Not Config";
                    break;
            }
            app.UseSwagger(c => {
                c.RouteTemplate = "swagger/{documentName}/swagger.json";
            });
            app.UseSwaggerUI(c => {
                c.RoutePrefix = "swagger/ui";
                c.SwaggerEndpoint("/swagger/"+ module.ToString().ToLower() + "/swagger.json", strLable);
            });
            return app;
        }
    }
}
