﻿using System;
using System.Collections.Generic;
using System.IO;
using System.Linq;
using System.Reflection;
using Microsoft.AspNetCore.Mvc;
using Siger.ApiCommon.Utilities;
using Siger.Middlelayer.Common;
using Siger.Middlelayer.Common.AppSettings;
using Siger.Middlelayer.Common.Helpers;
using Siger.Middlelayer.Common.ModuleEnum;
using Siger.Middlelayer.Repository.Data;
using Siger.Middlelayer.Repository.Repositories.Interface;
using Siger.Middlelayer.Utility.ExcelImport;
using Siger.Middlelayer.Utility.Helpers;
using Siger.Middlelayer.Utility.ImportEntities;

namespace Siger.ApiConfig.Controller
{
    public class MachineDownloadController : BaseController
    {
        private readonly ISigerProjectLevelRepository _levelRepository;
        private readonly ISigerProjectLevelSectionRepository _levelSectionRepository;
        private readonly ISigerProjectMachineRepository _machineRepository;
        public MachineDownloadController(ISigerProjectLevelRepository levelRepository, ISigerProjectLevelSectionRepository levelSectionRepository,
            ISigerProjectMachineRepository machineRepository)
        {
            _levelRepository = levelRepository;
            _levelSectionRepository = levelSectionRepository;
            _machineRepository = machineRepository;
        }

        [HttpGet]
        public IActionResult GetTemplate()
        {          

            return new ObjectResult(CreateMachineTemplate());
        }

        private string CreateMachineTemplate()
        {
            var language = _machineRepository.GetProjectLanguage(ProjectId);
            var columnNames = new List<string>();
            var titles = _levelRepository.GetLevelTitles(0, ProjectId);
            bool ColumnOnly(CustomAttributeData y) => y.AttributeType == typeof(ExcelColumn);
            var columns = typeof(MachineList)
                .GetProperties()
                .Where(x => x.CustomAttributes.Any(ColumnOnly)
                            && x.CustomAttributes.All(m => m.AttributeType != typeof(DonnetExportAttribute)))
                .Select(p => new
                {
                    Column = (language == 0 || !EpPlusLanguageHelper.LanguageDictionary.ContainsKey(p.GetCustomAttributes<ExcelColumn>().First().ColumnName))
                        ? p.GetCustomAttributes<ExcelColumn>().First().ColumnName
                        : EpPlusLanguageHelper.LanguageDictionary[p.GetCustomAttributes<ExcelColumn>().First().ColumnName]
                }).ToList();
            columnNames.AddRange(titles);
            columnNames.AddRange(columns.Select(m => m.Column));

            var helper = new EpPlusForMachineHelper();
            var rootDir = FileSystemHelper.GetPhysicalFolders(FileSystemHelper.CommonFileSetting.PhysicalFolder, FileSystemHelper.ExportFileName);
            var levels = new List<string>();
            var list = _levelSectionRepository.GetLevelSectionTree(ProjectId);
            foreach (var levelSectionTree in GetLastLevels(list))
            {
                var names = _levelSectionRepository.GetLevelSectionTitles(levelSectionTree.id, ProjectId);
                levels.Add(string.Join(',', names));
            }

            var temporaryFileName = $"西格云平台-设备台账导入模板_{DateTime.Now:yyyyMMddHHmmss}.xlsx";
            var fileName = Path.Combine(rootDir, temporaryFileName);
            helper.GenerateExcel(columnNames, levels, fileName);

            return $"{FileSystemHelper.CommonFileSetting.RequestPath}/{FileSystemHelper.ExportFileName}/{temporaryFileName}";
        }

        private IList<LevelSectionTree> GetLastLevels(IEnumerable<LevelSectionTree> models)
        {
            var result = new List<LevelSectionTree>();
            foreach (var levelSectionTree in models)
            {
                var model = models.FirstOrDefault(q => q.pid == levelSectionTree.id);
                if (model == null)
                {
                    result.Add(levelSectionTree);
                }
            }
            return result;
        }

        [HttpGet]
        public IActionResult GetSkfTemplate()
        {            
            return new ObjectResult(CreateSkfMachineTemplate());
        }

        private string CreateSkfMachineTemplate()
        {
            var language = _machineRepository.GetProjectLanguage(ProjectId);
            var columnNames = new List<string>();
            var titles = _levelRepository.GetLevelTitles(0, ProjectId);
            bool ColumnOnly(CustomAttributeData y) => y.AttributeType == typeof(ExcelColumn);
            var columns = typeof(MachineSkfList)
                .GetProperties()
                .Where(x => x.CustomAttributes.Any(ColumnOnly)
                            && x.CustomAttributes.All(m => m.AttributeType != typeof(DonnetExportAttribute)))
                .Select(p => new
                {
                    Column = (language == 0 || !EpPlusLanguageHelper.LanguageDictionary.ContainsKey(p.GetCustomAttributes<ExcelColumn>().First().ColumnName))
                        ? p.GetCustomAttributes<ExcelColumn>().First().ColumnName
                        : EpPlusLanguageHelper.LanguageDictionary[p.GetCustomAttributes<ExcelColumn>().First().ColumnName]
                }).ToList();
            columnNames.AddRange(titles);
            columnNames.AddRange(columns.Select(m => m.Column));

            var helper = new EpPlusForMachineHelper();
            var rootDir = FileSystemHelper.GetPhysicalFolders(FileSystemHelper.CommonFileSetting.PhysicalFolder, FileSystemHelper.ExportFileName);
            var levels = new List<string>();
            var list = _levelSectionRepository.GetLevelSectionTree(ProjectId);
            foreach (var levelSectionTree in GetLastLevels(list))
            {
                var names = _levelSectionRepository.GetLevelSectionTitles(levelSectionTree.id, ProjectId);
                levels.Add(string.Join(',', names));
            }

            var temporaryFileName = $"MachineImportTemplate_{DateTime.Now:yyyyMMddHHmmss}.xlsx";
            var fileName = Path.Combine(rootDir, temporaryFileName);
            helper.GenerateExcel(columnNames, levels, fileName);
            
            return $"{FileSystemHelper.CommonFileSetting.RequestPath}/{FileSystemHelper.ExportFileName}/{temporaryFileName}";
        }
    }
}