﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Threading.Tasks;
using Microsoft.AspNetCore.Mvc;
using Siger.Middlelayer.Common;
using Siger.Middlelayer.Common.Extensions;
using Siger.Middlelayer.Common.FieldEnum;
using Siger.Middlelayer.Common.Helpers;
using Siger.Middlelayer.Repository;
using Siger.Middlelayer.Repository.Entities;
using Siger.Middlelayer.Repository.Repositories.Interface;
using Siger.Middlelayer.Repository.Request;

namespace Siger.ApiConfig.Controller
{
    public class MonthReportTemplateController : BaseController
    {
        private readonly IUnitOfWork _unitOfWork;
        private readonly IMonthReportConfigTemplateRepository _monthReportConfigTemplate;

        public MonthReportTemplateController(IUnitOfWork unitOfWork, IMonthReportConfigTemplateRepository monthReportConfigTemplate)
        {
            this._unitOfWork = unitOfWork;
            this._monthReportConfigTemplate = monthReportConfigTemplate;
        }

        /// <summary>
        /// 根据月报获取 报表模板
        /// </summary>
        /// <param name="id"></param>
        /// <returns></returns>
        [HttpGet]
        public IActionResult GetTemplate(int id)
        {
            var data = _monthReportConfigTemplate.GetList(f => f.parent_id == id).ToList();
            var result = new List<RepTemplate>();
            foreach (var d in data)
            {
                var title = EnumHelper.GetEnumDesc((ReportTemplate)d.template_id);
                var machine = d.param.Split(',').Select(f => f.ToInt()).ToList();
                var ret = new RepTemplate
                {
                    Id = d.id,
                    TemplateId = d.template_id,
                    Title = d.title,
                    Axios = d.axios,
                    Tab = d.tab,
                    Val = d.val,
                    Machines = machine
                };
                result.Add(ret);
            }
            return new ObjectResult(result);
        }
        /// <summary>
        /// 添加 / 修改
        /// </summary>
        /// <param name="request"></param>
        /// <returns></returns>
        [HttpPost]
        public IActionResult Add([FromBody]RequestMonthConfig request)
        {
            var data = _monthReportConfigTemplate.GetList(f => f.parent_id == request.ParentId).ToList();
            foreach (var d in data)
            {
                _monthReportConfigTemplate.Delete(d.id);
            }
            foreach (var r in request.TemplateId)
            {
                var _param = r.Machines == null ? "" : string.Join(',', r.Machines);
                _monthReportConfigTemplate.Insert(new siger_project_monthreport_config_template
                {
                    parent_id = request.ParentId,
                    project_id = ProjectId,
                    template_id = r.TemplateId,
                    title = r.Title,
                    status = (int)RowState.Valid,
                    create_time = DateTime.Now,
                    axios = r.Axios,
                    tab = r.Tab,
                    val = r.Val,
                    param = _param
                });
            }
            if (_unitOfWork.Commit() > 0)
                return new ObjectResult(CommonEnum.Succefull);
            else
                throw new BadRequestException(CommonEnum.Fail);
        }
        /// <summary>
        /// 修改模板
        /// </summary>
        /// <param name="request"></param>
        /// <returns></returns>
        [HttpPost]
        public IActionResult Modify([FromBody]RequestTemplateModify request)
        {
            if (!request.Machines.Any())
                throw new BadRequestException(RequestEnum.LevelSectionNotFound);

            var templateObj = _monthReportConfigTemplate.Get(f => f.project_id == ProjectId && f.id == request.Id);
            if (templateObj == null)
                throw new BadRequestException(CommonEnum.RecordNotFound);

            var _param = string.Join(',', request.Machines);
            templateObj.template_id = request.TemplateId;
            templateObj.title = request.Title;
            templateObj.status = (int)RowState.Valid;
            templateObj.create_time = DateTime.Now;
            templateObj.axios = request.Axios;
            templateObj.tab = request.Tab;
            templateObj.val = request.Val;
            templateObj.param = _param;

            if (_unitOfWork.Commit() > 0)
                return new ObjectResult(CommonEnum.Succefull);
            else
                throw new BadRequestException(CommonEnum.Fail);
        }

        /// <summary>
        /// 删除模板
        /// </summary>
        /// <param name="id"></param>
        /// <returns></returns>
        [HttpGet]
        public IActionResult Del(int id)
        {
            var templateObj = _monthReportConfigTemplate.Get(f => f.project_id == ProjectId && f.id == id);
            if (templateObj == null)
                throw new BadRequestException(CommonEnum.RecordNotFound);
            _monthReportConfigTemplate.Delete(templateObj.id);
            if (_unitOfWork.Commit() > 0)
                return new ObjectResult(CommonEnum.Succefull);
            else
                throw new BadRequestException(CommonEnum.Fail);
        }
    }
}
