﻿using System.Collections.Generic;
using System.Linq;
using Microsoft.AspNetCore.Mvc;
using Siger.Middlelayer.Common;
using Siger.Middlelayer.Log;
using Siger.Middlelayer.Repository.Repositories.Interface;
using Siger.Middlelayer.Repository.Response;
using Siger.Middlelayer.Share.Constant;

namespace Siger.ApiConfig.Controller
{
    public class PositionController : BaseController
    {
        private readonly ISigerProjectLevelSectionRepository _projectLevelSection;
        private readonly ISigerDict _sigerDict;

        public PositionController(ISigerProjectLevelSectionRepository projectLevelSection ,ISigerDict sigerDict)
        {
            _projectLevelSection = projectLevelSection;
            _sigerDict = sigerDict;
        }

        [HttpGet]
        public IActionResult GetLine()
        {
            var result = _projectLevelSection.GetAccLines(ProjectId);
            if (result.Any())
                return new ObjectResult(result);
            throw new BadRequestException(CommonEnum.RecordNotFound);
        }

        [HttpGet]
        public IActionResult GetStation(int line)
        {
            var obj = _projectLevelSection.GetAccStationByline(ProjectId, line);
            if (obj.Any())
                return new ObjectResult(obj);
            throw new BadRequestException(CommonEnum.RecordNotFound);
        }

       
    }

}