﻿using System.Linq;
using Microsoft.AspNetCore.Mvc;
using Siger.ApiCommon.Exceptions;
using Siger.Middlelayer.Common;
using Siger.Middlelayer.Repository;
using Siger.Middlelayer.Repository.Entities;
using Siger.Middlelayer.Repository.Repositories.Interface;
using Siger.Middlelayer.Repository.Request;

namespace Siger.ApiConfig.Controller
{
    public class ProjectGroupController : BaseController
    {
        private readonly IUnitOfWork _unitOfWork;
        private readonly ISigerProjectGroupRepository _projectGroupRepository;
        private readonly ISigerProjectUserGroupRepository _projectUserGroupRepository;
        private readonly ISigerProjectStationRepository _projectStationRepository;
        public ProjectGroupController(IUnitOfWork unitOfWork, ISigerProjectGroupRepository projectGroupRepository,
            ISigerProjectUserGroupRepository projectUserGroupRepository, ISigerProjectStationRepository projectStationRepository)
        {
            _unitOfWork = unitOfWork;
            _projectGroupRepository = projectGroupRepository;
            _projectUserGroupRepository = projectUserGroupRepository;
            _projectStationRepository = projectStationRepository;
        }

        [HttpGet]
        public IActionResult GetAllGroups()
        {
            var list = _projectGroupRepository.GetList(q => q.projectid == ProjectId && q.status == (int)RowState.Valid);
            return new ObjectResult(list);
        }

        [HttpGet]
        public IActionResult GetGroups(int departid)
        {
            var list = _projectGroupRepository.GetList(q => q.departid == departid && q.projectid == ProjectId && q.status == (int) RowState.Valid);
            
            return new ObjectResult(list.ToList());
        }

        [HttpGet]
        public IActionResult GetUserGroups(int departid)
        {
            var list = _projectUserGroupRepository.GetList(q => q.sectionid == departid && q.projectid == ProjectId && q.status == (int)RowState.Valid);
            return new ObjectResult(list.ToList());
        }

        [HttpPost]
        public IActionResult AddGroups([FromBody]RequestAddProjectGroup request)
        {
            if (request.groups == null || !request.groups.Any())
            {
                throw new BadRequestException(RequestEnum.GroupsNotFound);
            }

            foreach (var groupInfo in request.groups.ToList())
            {
                if (groupInfo.groupid == 0)
                {
                    var isExist = _projectGroupRepository.Get(q => q.name == groupInfo.name && q.status == (int) RowState.Valid
                                                                                            && q.projectid == ProjectId);
                    if (isExist != null)
                    {
                        throw new BadRequestException(RequestEnum.NameHasExist);
                    }
                    var entity = new siger_project_group();
                    entity.name = groupInfo.name;
                    entity.departid = request.departid;
                    entity.projectid = ProjectId;
                    _projectGroupRepository.Insert(entity);
                }
                else
                {
                    var entity = _projectGroupRepository.Get(groupInfo.groupid);
                    if (entity == null || entity.status != (int)RowState.Valid)
                    {
                        throw new BadRequestException(RequestEnum.ProjectGroupNotFound);
                    }
                    var isExist = _projectGroupRepository.Get(q => q.name == groupInfo.name && q.status == (int)RowState.Valid
                                                                   && q.id != groupInfo.groupid && q.projectid == ProjectId);
                    if (isExist != null)
                    {
                        throw new BadRequestException(RequestEnum.NameHasExist);
                    }
                    entity.name = groupInfo.name;
                    _projectGroupRepository.Update(entity);
                }
            }

            if (_unitOfWork.Commit() > 0)
            {
                return new ObjectResult(CommonEnum.Succefull);
            }
            throw new BadRequestException(CommonEnum.SystemExcetion);
        }

        [HttpPost]
        public IActionResult DelGroups(int id)
        {
            _projectGroupRepository.Delete(id);

            _projectUserGroupRepository.DeleteUser_GroupByGroupId(id);

            var entities = _projectStationRepository.GetList(q => q.groupid == id && q.status == (int)RowState.Valid).ToList();
            foreach(var station in entities)
            {
                _projectStationRepository.Delete(station);
            }

            _unitOfWork.Commit();
            return new ObjectResult(CommonEnum.Succefull);
        }
    }
}