﻿

using Siger.ApiDashboard.Tasks.Model;
using Siger.Middlelayer.Common.Helpers;
using Siger.Middlelayer.Repository.Entities;
using Siger.Middlelayer.Share.Models;
using System;
using System.Collections.Generic;
using System.IO;
using System.Linq;
using System.Threading.Tasks;

namespace Siger.ApiDashboard.Tasks.Reports
{
    internal class ReporterMain : ReporBase
    {

        public ReporterMain()
        {
            var fileName = Path.Combine(RootDir, "cnc.New_Template.html");
            if (!File.Exists(fileName))
                throw new Exception("templates file not found.");

            OriginalContent = FileHelper.ReadFile(fileName);
            if (string.IsNullOrWhiteSpace(OriginalContent))
                throw new Exception("read template file failed.");
        }
        /// <summary>
        /// 转换文件
        /// </summary>
        /// <param name="config"></param>
        /// <param name="dataStr"></param>
        /// <param name="range"></param>
        /// <returns></returns>

        public override ConvertPdfResult GeneratePdf(siger_project_monthreport_config config, string dataStr)
        {
            ReplaceHtml(config, dataStr);
            return ConvertHelper.ConvertToPdf(OriginalContent, config.send_type);
        }

        protected override void ReplaceHtml(siger_project_monthreport_config config, string dataStr)
        {
            var range = ReportDbHelper.Instance.TimeRange(config);
            var timeRange = range.StartTime + " - " + range.EndTime;

            OriginalContent = OriginalContent.Replace("{title}", config.name);
            OriginalContent = OriginalContent.Replace("{timeRange}", timeRange);
            OriginalContent = OriginalContent.Replace("{dataArray}", dataStr);
        }
    }
}
