﻿using Microsoft.VisualBasic.CompilerServices;
using System;
using System.Runtime.CompilerServices;
using System.Text;

namespace Siger.ApiQMS.Utility
{
    public class CheckSnHelper
    {
        public string campoP;//物料编号 有用
        public string campoQ;//数量 有用
        public string campoT;//批次码 有用
        public string campo3Q;
        public string campo4Q;
        public string campo5Q;
        public string campo4D;//20099 日期 2020年第99天
        public string campo12V;//供应商Duns码
        public string campo11S;
        public string campo13V;
        public string campo1T;
        public string campo10S;
        public string campoK;

        public CheckSnHelper()
        {
            campoP = "";
            campoQ = "";
            campoT = "";
            campo3Q = "";
            campo4Q = "";
            campo5Q = "";
            campo4D = "";
            campo12V = "";
            campo11S = "";
            campo13V = "";
            campo1T = "";
            campo10S = "";
            campoK = "";
        }

        public void SplitBarcode(string barcode)
        {
            string value = "\u001d";
            string find = Conversions.ToString(StringsHelper.Chr(187));
            string[] array = barcode.Split(new char[]
            {
                Conversions.ToChar(value)
            });
            checked
            {
                if (barcode.StartsWith("[)>"))
                {
                    int num = StringsHelper.UBound(array, 1);
                    for (int i = 0; i <= num; i++)
                    {
                        string text = Xtrim(array[i]);
                        if (Operators.CompareString(text, "", false) != 0)
                        {
                            try
                            {
                                if (Operators.CompareString(Conversions.ToString(text[0]), "P", false) == 0 && text.Length <= 50)
                                {
                                    this.campoP = StringsHelper.Mid(array[i].Remove(0, 1), 1, 50);
                                }
                            }
                            catch (Exception expr_A7)
                            {
                                ProjectData.SetProjectError(expr_A7);
                                ProjectData.ClearProjectError();
                            }
                            try
                            {
                                if (Operators.CompareString(Conversions.ToString(text[0]), "T", false) == 0 && text.Length <= 50)
                                {
                                    this.campoT = StringsHelper.Mid(array[i].Remove(0, 1), 1, 50);
                                }
                            }
                            catch (Exception expr_F5)
                            {
                                ProjectData.SetProjectError(expr_F5);
                                ProjectData.ClearProjectError();
                            }
                            try
                            {
                                if (Operators.CompareString(Conversions.ToString(text[0]), "Q", false) == 0)
                                {
                                    this.campoQ = array[i].Remove(0, 1);
                                    this.campoQ = StringsHelper.Replace(Conversions.ToString(this.campoQ), "?", "", 1, -1, CompareMethod.Binary);
                                    this.campoQ = StringsHelper.Replace(Conversions.ToString(this.campoQ), find, "", 1, -1, CompareMethod.Binary);
                                    this.campoQ = StringsHelper.Replace(Conversions.ToString(this.campoQ), ".", "", 1, -1, CompareMethod.Binary);
                                    this.campoQ = StringsHelper.Replace(Conversions.ToString(this.campoQ), ",", "", 1, -1, CompareMethod.Binary);
                                    this.campoQ = Xtrim(RuntimeHelpers.GetObjectValue(this.campoQ));
                                }
                            }
                            catch (Exception expr_1D2)
                            {
                                ProjectData.SetProjectError(expr_1D2);
                                ProjectData.ClearProjectError();
                            }
                            try
                            {
                                if (Operators.CompareString(Conversions.ToString(text[1]), "Q", false) == 0)
                                {
                                    switch (text[0])
                                    {
                                        case '3':
                                            this.campo3Q = StringsHelper.Mid(array[i].Remove(0, 2), 1, 5);
                                            break;
                                        case '4':
                                            this.campo4Q = StringsHelper.Mid(array[i].Remove(0, 2), 1, 5);
                                            break;
                                        case '5':
                                            this.campo5Q = StringsHelper.Mid(array[i].Remove(0, 2), 1, 5);
                                            break;
                                    }
                                }
                            }
                            catch (Exception expr_26A)
                            {
                                ProjectData.SetProjectError(expr_26A);
                                ProjectData.ClearProjectError();
                            }
                            try
                            {
                                if ((Operators.CompareString(Conversions.ToString(text[0]), "4", false) == 0 & Operators.CompareString(Conversions.ToString(text[1]), "D", false) == 0) && text.Replace(" ", "").Length <= 7)
                                {
                                    this.campo4D = StringsHelper.Mid(array[i].Remove(0, 2), 1, 5);
                                }
                            }
                            catch (Exception expr_2E3)
                            {
                                ProjectData.SetProjectError(expr_2E3);
                                ProjectData.ClearProjectError();
                            }
                            try
                            {
                                if (Operators.CompareString(Conversions.ToString(text[0]), "1", false) == 0)
                                {
                                    if (Operators.CompareString(Conversions.ToString(text[1]), "2", false) == 0 && text.Length <= 12)
                                    {
                                        this.campo12V = StringsHelper.Mid(array[i].Remove(0, 3), 1, 9);
                                    }
                                    if (Operators.CompareString(Conversions.ToString(text[1]), "1", false) == 0 && text.Length <= 50)
                                    {
                                        this.campo11S = StringsHelper.Mid(array[i].Remove(0, 3), 1, 50);
                                    }
                                    if (Operators.CompareString(Conversions.ToString(text[1]), "3", false) == 0 && text.Length <= 12)
                                    {
                                        this.campo13V = StringsHelper.Mid(array[i].Remove(0, 3), 1, 9);
                                    }
                                    if (Operators.CompareString(Conversions.ToString(text[1]), "T", false) == 0 && text.Length <= 50)
                                    {
                                        this.campo1T = StringsHelper.Mid(array[i].Remove(0, 2), 1, 50);
                                    }
                                    if (Operators.CompareString(Conversions.ToString(text[1]), "0", false) == 0 && text.Length <= 50)
                                    {
                                        this.campo10S = StringsHelper.Mid(array[i].Remove(0, 3), 1, 50);
                                    }
                                }
                            }
                            catch (Exception expr_43D)
                            {
                                ProjectData.SetProjectError(expr_43D);
                                ProjectData.ClearProjectError();
                            }

                            try
                            {
                                if (Operators.CompareString(Conversions.ToString(text[0]), "K", false) == 0 && text.Length <= 50)
                                {
                                    this.campoK = array[i].Remove(0, 1);
                                }
                            }
                            catch (Exception expr_483)
                            {
                                ProjectData.SetProjectError(expr_483);
                                ProjectData.ClearProjectError();
                            }
                        }
                    }
                }
            }
        }

        private string Xtrim(object a)
        {
            string result;
            if (Operators.ConditionalCompareObjectEqual(a, null, false))
            {
                result = "";
            }
            else
            {
                result = StringsHelper.Trim(this.Blk(ref a));
            }
            return result;
        }

        private string Blk(ref object _stringa)
        {
            string text = Conversions.ToString(_stringa);
            int num = StringsHelper.Len(text);
            checked
            {
                //for (int i = 1; i <= num; i++)
                //{
                //    if (StringsHelper.Asc(StringsHelper.Mid(text, i, 1)) < 32)
                //    {
                //        StringsHelper.MidStmtStr(ref text, i, 1, " ");
                //    }
                //}
                return text;
            }
        }

        /// <summary>
        /// Ascii转字符串
        /// </summary>
        /// <param name="ascii">4=EOT\28=FS\29=GS</param>
        /// <returns></returns>
        public string AsciiToString(string ascii)
        {
            string returnValue = "";
            string[] split = ascii.Split(',');
            foreach (var s in split)
            {
                returnValue += Encoding.ASCII.GetString(new byte[] { (byte)int.Parse(s) });
            }
            return returnValue;
        }
    }
}
