﻿using System.Linq;
using Microsoft.AspNetCore.Mvc;
using Siger.ApiCommon.Result;
using Siger.Middlelayer.Common;
using Siger.Middlelayer.Repository;
using Siger.Middlelayer.Repository.Repositories.Interface;
using Siger.Middlelayer.TlmRepository.Entities;
using Siger.Middlelayer.TlmRepository.Repositories.Interface;
using Siger.Middlelayer.TlmRepository.Request;

namespace Siger.ApiTLM.Controllers
{
    public class ToolCabinetController : BaseController
    {
        private readonly IUnitOfWork _unitOfWork;
        private readonly IToollifeCabinetConfigRepository _cabinetConfig;
        private readonly Isiger_wms_bussinese_contactsRepository _bussineseContactsRepository;
        private readonly IToollifeCabinetReceiveRepository _cabinetReceiveRepository;
        private readonly IToollifeCabinetReceiveDetailRepository _cabinetReceiveDetailRepository;
        public ToolCabinetController(IUnitOfWork unitOfWork, IToollifeCabinetConfigRepository cabinetConfig, Isiger_wms_bussinese_contactsRepository bussineseContactsRepository,
            IToollifeCabinetReceiveRepository cabinetReceiveRepository, IToollifeCabinetReceiveDetailRepository cabinetReceiveDetailRepository)
        {
            _unitOfWork = unitOfWork;
            _cabinetConfig = cabinetConfig;
            _bussineseContactsRepository = bussineseContactsRepository;
            _cabinetReceiveRepository = cabinetReceiveRepository;
            _cabinetReceiveDetailRepository = cabinetReceiveDetailRepository;
        }
        /// <summary>
        /// 获取刀具柜配置信息
        /// </summary>
        /// <returns></returns>
        [HttpPost]
        public IActionResult GetCabinetConfiguration([FromBody]RequestCabinetConfiguration requestCabinet)
        {
            if (!string.IsNullOrWhiteSpace(requestCabinet.Name))
            {
                var resp = _cabinetConfig.GetPagedList(requestCabinet.page, requestCabinet.pagesize, f => f.Name.Equals(requestCabinet.Name) && f.project_id.Equals(ProjectId) && f.status == RowState.Valid.GetHashCode(), "id");
                return new PagedObjectResult(resp.Data, resp.Total, requestCabinet.page, requestCabinet.pagesize);
            }
            if (!string.IsNullOrWhiteSpace(requestCabinet.CabinetCode))
            {
                var resp = _cabinetConfig.GetPagedList(requestCabinet.page, requestCabinet.pagesize, f => f.Cabinetcode.Equals(requestCabinet.CabinetCode) && f.project_id.Equals(ProjectId) && f.status == RowState.Valid.GetHashCode(), "id");
                return new PagedObjectResult(resp.Data, resp.Total, requestCabinet.page, requestCabinet.pagesize);
            }
            var response = _cabinetConfig.GetPagedList(requestCabinet.page, requestCabinet.pagesize, f => f.project_id.Equals(ProjectId) && f.status == RowState.Valid.GetHashCode(), "id");
            return new PagedObjectResult(response.Data, response.Total, requestCabinet.page, requestCabinet.pagesize);
        }
        /// <summary>
        /// 删除刀具柜配置信息
        /// </summary>
        /// <param name="requestCabinet"></param>
        /// <returns></returns>
        [HttpPost]
        public IActionResult RemoveCabinetConfiguration([FromBody] RequestCabinetConfiguration requestCabinet)
        {
            var data = _cabinetConfig.Get(f =>
                f.id == requestCabinet.Id && f.project_id.Equals(ProjectId) &&
                f.status == RowState.Valid.GetHashCode());
            if (data == null)
            {
                return new ObjectResult(CommonEnum.Succefull);
            }
            _cabinetConfig.Delete(data);
            if (_unitOfWork.Commit() > 0)
            {
                return new ObjectResult(CommonEnum.Succefull);
            }

            throw new BadRequestException(CommonEnum.DeleteFaild);
        }
        /// <summary>
        /// 修改刀具柜配置信息
        /// </summary>
        /// <param name="requestCabinet"></param>
        /// <returns></returns>
        [HttpPost]
        public IActionResult ModifyCabinetConfiguration([FromBody] RequestCabinetConfiguration requestCabinet)
        {
            var data = _cabinetConfig.Get(f =>
                f.id == requestCabinet.Id && f.project_id.Equals(ProjectId) &&
                f.status == RowState.Valid.GetHashCode());
            if (data == null)
            {
                throw new BadRequestException(CommonEnum.UpdateFaild);
            }
            //CabinetCode唯一性校验
            var temp = _cabinetConfig.GetList(f => f.id != requestCabinet.Id &&
                f.Cabinetcode == requestCabinet.CabinetCode && f.project_id.Equals(ProjectId) &&
                f.status == RowState.Valid.GetHashCode());
            if (temp.Any())
            {
                throw new BadRequestException(CommonEnum.RecordExits);
            }
            data.Name = requestCabinet.Name;
            data.Cabinetcode = requestCabinet.CabinetCode;
            data.Inventoryapi = requestCabinet.Inventoryapi;
            data.Pickapi = requestCabinet.Pickapi;
            data.Suppliercode = requestCabinet.SupplierCode;
            data.Suppliername = requestCabinet.SupplierName;
            _cabinetConfig.Update(data);
            if (_unitOfWork.Commit() > 0)
            {
                return new ObjectResult(CommonEnum.Succefull);
            }
            throw new BadRequestException(CommonEnum.UpdateFaild);
        }
        /// <summary>
        /// 新增刀具柜配置信息
        /// </summary>
        /// <param name="requestCabinet"></param>
        /// <returns></returns>
        [HttpPost]
        public IActionResult InsertCabinetConfiguration([FromBody] RequestCabinetConfiguration requestCabinet)
        {
            var data = _cabinetConfig.Get(f =>
                f.Cabinetcode == requestCabinet.CabinetCode && f.project_id.Equals(ProjectId) &&
                f.status == RowState.Valid.GetHashCode());
            if (data != null)
            {
                throw new BadRequestException(CommonEnum.RecordExits);
            }
            var tempData = new SigerProjectToollifeCabinetConfig
            {
                Name = requestCabinet.Name,
                Cabinetcode = requestCabinet.CabinetCode,
                Inventoryapi = requestCabinet.Inventoryapi,
                Pickapi = requestCabinet.Pickapi,
                Suppliercode = requestCabinet.SupplierCode,
                Suppliername = requestCabinet.SupplierName,
                project_id = ProjectId,
            };
            _cabinetConfig.Insert(tempData);
            if (_unitOfWork.Commit() > 0)
            {
                return new ObjectResult(CommonEnum.Succefull);
            }
            throw new BadRequestException(CommonEnum.Fail);
        }
        /// <summary>
        /// 获取WMS供应商列表
        /// </summary>
        /// <returns></returns>
        [HttpGet]
        public IActionResult GetSuppliers()
        {
            var suppliers = _bussineseContactsRepository.GetSupplierData(ProjectId);
            return new ObjectResult(suppliers);
        }
        /// <summary>
        /// 刀具柜领用记录查询
        /// </summary>
        /// <param name="requestCabinetReceiveData"></param>
        /// <returns></returns>
        [HttpPost]
        public IActionResult GetCabinetReceiveData([FromBody]RequestCabinetReceiveData requestCabinetReceiveData)
        {
            var data = _cabinetReceiveRepository.GetCabinetReceiveData(requestCabinetReceiveData, ProjectId);
            return new PagedObjectResult(data.Data, data.Total, requestCabinetReceiveData.page, requestCabinetReceiveData.pagesize);
        }
        /// <summary>
        /// 刀具柜领用明细查询
        /// </summary>
        /// <param name="requestCabinetReceiveData"></param>
        /// <returns></returns>
        [HttpPost]
        public IActionResult GetCabinetReceiveDetail([FromBody]RequestCabinetReceiveData requestCabinetReceiveData)
        {
            var data = _cabinetReceiveDetailRepository.GetPagedList(requestCabinetReceiveData.page, requestCabinetReceiveData.pagesize, f =>
                f.project_id.Equals(ProjectId) && f.status != RowState.Invalid.GetHashCode() &&
                f.Mid.Equals(requestCabinetReceiveData.Id));
            return new PagedObjectResult(data.Data,data.Total,requestCabinetReceiveData.page,requestCabinetReceiveData.pagesize);
        }


    }
}